/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.SessionManagerOutputUrl;

@SdkInternalApi
public class SessionManagerOutputUrlMarshaller {
    private static final MarshallingInfo<String> S3OUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputUrl").build();
    private static final MarshallingInfo<String> CLOUDWATCHOUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchOutputUrl").build();
    private static final SessionManagerOutputUrlMarshaller instance = new SessionManagerOutputUrlMarshaller();

    public static SessionManagerOutputUrlMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionManagerOutputUrl sessionManagerOutputUrl, ProtocolMarshaller protocolMarshaller) {
        if (sessionManagerOutputUrl == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sessionManagerOutputUrl.getS3OutputUrl(), S3OUTPUTURL_BINDING);
            protocolMarshaller.marshall((Object)sessionManagerOutputUrl.getCloudWatchOutputUrl(), CLOUDWATCHOUTPUTURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

