/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.OperatingSystem;
import com.amazonaws.services.simplesystemsmanagement.model.PatchAction;
import com.amazonaws.services.simplesystemsmanagement.model.PatchComplianceLevel;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchSource;
import com.amazonaws.services.simplesystemsmanagement.model.transform.BaselineOverrideMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BaselineOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private String operatingSystem;
    private PatchFilterGroup globalFilters;
    private PatchRuleGroup approvalRules;
    private SdkInternalList<String> approvedPatches;
    private String approvedPatchesComplianceLevel;
    private SdkInternalList<String> rejectedPatches;
    private String rejectedPatchesAction;
    private Boolean approvedPatchesEnableNonSecurity;
    private SdkInternalList<PatchSource> sources;

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public BaselineOverride withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public BaselineOverride withOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem.toString();
        return this;
    }

    public void setGlobalFilters(PatchFilterGroup globalFilters) {
        this.globalFilters = globalFilters;
    }

    public PatchFilterGroup getGlobalFilters() {
        return this.globalFilters;
    }

    public BaselineOverride withGlobalFilters(PatchFilterGroup globalFilters) {
        this.setGlobalFilters(globalFilters);
        return this;
    }

    public void setApprovalRules(PatchRuleGroup approvalRules) {
        this.approvalRules = approvalRules;
    }

    public PatchRuleGroup getApprovalRules() {
        return this.approvalRules;
    }

    public BaselineOverride withApprovalRules(PatchRuleGroup approvalRules) {
        this.setApprovalRules(approvalRules);
        return this;
    }

    public List<String> getApprovedPatches() {
        if (this.approvedPatches == null) {
            this.approvedPatches = new SdkInternalList();
        }
        return this.approvedPatches;
    }

    public void setApprovedPatches(Collection<String> approvedPatches) {
        if (approvedPatches == null) {
            this.approvedPatches = null;
            return;
        }
        this.approvedPatches = new SdkInternalList(approvedPatches);
    }

    public BaselineOverride withApprovedPatches(String ... approvedPatches) {
        if (this.approvedPatches == null) {
            this.setApprovedPatches((Collection<String>)new SdkInternalList(approvedPatches.length));
        }
        for (String ele : approvedPatches) {
            this.approvedPatches.add((Object)ele);
        }
        return this;
    }

    public BaselineOverride withApprovedPatches(Collection<String> approvedPatches) {
        this.setApprovedPatches(approvedPatches);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
    }

    public String getApprovedPatchesComplianceLevel() {
        return this.approvedPatchesComplianceLevel;
    }

    public BaselineOverride withApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.setApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
        return this;
    }

    public BaselineOverride withApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel.toString();
        return this;
    }

    public List<String> getRejectedPatches() {
        if (this.rejectedPatches == null) {
            this.rejectedPatches = new SdkInternalList();
        }
        return this.rejectedPatches;
    }

    public void setRejectedPatches(Collection<String> rejectedPatches) {
        if (rejectedPatches == null) {
            this.rejectedPatches = null;
            return;
        }
        this.rejectedPatches = new SdkInternalList(rejectedPatches);
    }

    public BaselineOverride withRejectedPatches(String ... rejectedPatches) {
        if (this.rejectedPatches == null) {
            this.setRejectedPatches((Collection<String>)new SdkInternalList(rejectedPatches.length));
        }
        for (String ele : rejectedPatches) {
            this.rejectedPatches.add((Object)ele);
        }
        return this;
    }

    public BaselineOverride withRejectedPatches(Collection<String> rejectedPatches) {
        this.setRejectedPatches(rejectedPatches);
        return this;
    }

    public void setRejectedPatchesAction(String rejectedPatchesAction) {
        this.rejectedPatchesAction = rejectedPatchesAction;
    }

    public String getRejectedPatchesAction() {
        return this.rejectedPatchesAction;
    }

    public BaselineOverride withRejectedPatchesAction(String rejectedPatchesAction) {
        this.setRejectedPatchesAction(rejectedPatchesAction);
        return this;
    }

    public BaselineOverride withRejectedPatchesAction(PatchAction rejectedPatchesAction) {
        this.rejectedPatchesAction = rejectedPatchesAction.toString();
        return this;
    }

    public void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
        this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
    }

    public Boolean getApprovedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public BaselineOverride withApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
        this.setApprovedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity);
        return this;
    }

    public Boolean isApprovedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public List<PatchSource> getSources() {
        if (this.sources == null) {
            this.sources = new SdkInternalList();
        }
        return this.sources;
    }

    public void setSources(Collection<PatchSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new SdkInternalList(sources);
    }

    public BaselineOverride withSources(PatchSource ... sources) {
        if (this.sources == null) {
            this.setSources((Collection<PatchSource>)new SdkInternalList(sources.length));
        }
        for (PatchSource ele : sources) {
            this.sources.add((Object)ele);
        }
        return this;
    }

    public BaselineOverride withSources(Collection<PatchSource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getGlobalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.getGlobalFilters()).append(",");
        }
        if (this.getApprovalRules() != null) {
            sb.append("ApprovalRules: ").append(this.getApprovalRules()).append(",");
        }
        if (this.getApprovedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.getApprovedPatches()).append(",");
        }
        if (this.getApprovedPatchesComplianceLevel() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(this.getApprovedPatchesComplianceLevel()).append(",");
        }
        if (this.getRejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.getRejectedPatches()).append(",");
        }
        if (this.getRejectedPatchesAction() != null) {
            sb.append("RejectedPatchesAction: ").append(this.getRejectedPatchesAction()).append(",");
        }
        if (this.getApprovedPatchesEnableNonSecurity() != null) {
            sb.append("ApprovedPatchesEnableNonSecurity: ").append(this.getApprovedPatchesEnableNonSecurity()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaselineOverride)) {
            return false;
        }
        BaselineOverride other = (BaselineOverride)obj;
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getGlobalFilters() == null ^ this.getGlobalFilters() == null) {
            return false;
        }
        if (other.getGlobalFilters() != null && !other.getGlobalFilters().equals(this.getGlobalFilters())) {
            return false;
        }
        if (other.getApprovalRules() == null ^ this.getApprovalRules() == null) {
            return false;
        }
        if (other.getApprovalRules() != null && !other.getApprovalRules().equals(this.getApprovalRules())) {
            return false;
        }
        if (other.getApprovedPatches() == null ^ this.getApprovedPatches() == null) {
            return false;
        }
        if (other.getApprovedPatches() != null && !other.getApprovedPatches().equals(this.getApprovedPatches())) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() == null ^ this.getApprovedPatchesComplianceLevel() == null) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() != null && !other.getApprovedPatchesComplianceLevel().equals(this.getApprovedPatchesComplianceLevel())) {
            return false;
        }
        if (other.getRejectedPatches() == null ^ this.getRejectedPatches() == null) {
            return false;
        }
        if (other.getRejectedPatches() != null && !other.getRejectedPatches().equals(this.getRejectedPatches())) {
            return false;
        }
        if (other.getRejectedPatchesAction() == null ^ this.getRejectedPatchesAction() == null) {
            return false;
        }
        if (other.getRejectedPatchesAction() != null && !other.getRejectedPatchesAction().equals(this.getRejectedPatchesAction())) {
            return false;
        }
        if (other.getApprovedPatchesEnableNonSecurity() == null ^ this.getApprovedPatchesEnableNonSecurity() == null) {
            return false;
        }
        if (other.getApprovedPatchesEnableNonSecurity() != null && !other.getApprovedPatchesEnableNonSecurity().equals(this.getApprovedPatchesEnableNonSecurity())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalFilters() == null ? 0 : this.getGlobalFilters().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalRules() == null ? 0 : this.getApprovalRules().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatches() == null ? 0 : this.getApprovedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesComplianceLevel() == null ? 0 : this.getApprovedPatchesComplianceLevel().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatches() == null ? 0 : this.getRejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatchesAction() == null ? 0 : this.getRejectedPatchesAction().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesEnableNonSecurity() == null ? 0 : this.getApprovedPatchesEnableNonSecurity().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public BaselineOverride clone() {
        try {
            return (BaselineOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BaselineOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

