/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.ServletLambdaContainerHandlerBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.SpringBootLambdaContainerHandler;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.WebApplicationType;

public final class SpringBootProxyHandlerBuilder<RequestType>
extends ServletLambdaContainerHandlerBuilder<RequestType, AwsProxyResponse, HttpServletRequest, SpringBootLambdaContainerHandler<RequestType, AwsProxyResponse>, SpringBootProxyHandlerBuilder<RequestType>> {
    private Class<?> springBootInitializer;
    private String[] profiles;
    private WebApplicationType applicationType = WebApplicationType.REACTIVE;

    protected SpringBootProxyHandlerBuilder<RequestType> self() {
        return this;
    }

    public SpringBootProxyHandlerBuilder<RequestType> springBootApplication(Class<?> app) {
        this.springBootInitializer = app;
        return this.self();
    }

    public SpringBootProxyHandlerBuilder<RequestType> profiles(String ... profiles) {
        this.profiles = profiles;
        return this.self();
    }

    public SpringBootProxyHandlerBuilder<RequestType> servletApplication() {
        this.applicationType = WebApplicationType.SERVLET;
        return this.self();
    }

    public SpringBootLambdaContainerHandler<RequestType, AwsProxyResponse> build() throws ContainerInitializationException {
        this.validate();
        if (this.springBootInitializer == null) {
            throw new ContainerInitializationException("Missing spring boot application class in builder", null);
        }
        SpringBootLambdaContainerHandler handler = new SpringBootLambdaContainerHandler(this.requestTypeClass, this.responseTypeClass, this.requestReader, this.responseWriter, this.securityContextWriter, this.exceptionHandler, this.springBootInitializer, this.initializationWrapper, this.applicationType);
        if (this.profiles != null) {
            handler.activateSpringProfiles(this.profiles);
        }
        return handler;
    }

    public SpringBootLambdaContainerHandler<RequestType, AwsProxyResponse> buildAndInitialize() throws ContainerInitializationException {
        AwsLambdaServletContainerHandler handler = this.build();
        this.initializationWrapper.start((LambdaContainerHandler)handler);
        return handler;
    }
}

