/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.BaseYamlNode;
import com.amihaiemil.eoyaml.Node;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.Iterator;
import java.util.Set;

public abstract class BaseYamlMapping
extends BaseYamlNode
implements YamlMapping {
    @Override
    public final Node type() {
        return Node.MAPPING;
    }

    public final int hashCode() {
        int hash = 0;
        for (YamlNode key : this.keys()) {
            hash += key.hashCode();
        }
        for (YamlNode value : this.values()) {
            hash += value.hashCode();
        }
        return hash;
    }

    public final boolean equals(Object other) {
        boolean result = other == null || !(other instanceof YamlMapping) ? false : (this == other ? true : this.compareTo((YamlMapping)other) == 0);
        return result;
    }

    @Override
    public final int compareTo(YamlNode other) {
        int result = 0;
        if (other == null || !(other instanceof YamlMapping)) {
            result = 1;
        } else if (this != other) {
            BaseYamlMapping map = (BaseYamlMapping)other;
            Set<YamlNode> keys = this.keys();
            Set<YamlNode> otherKeys = map.keys();
            if (keys.size() > otherKeys.size()) {
                result = 1;
            } else if (keys.size() < otherKeys.size()) {
                result = -1;
            } else {
                Iterator<YamlNode> keysIt = keys.iterator();
                Iterator<YamlNode> otherKeysIt = otherKeys.iterator();
                Iterator<YamlNode> values = this.values().iterator();
                Iterator<YamlNode> otherVals = map.values().iterator();
                while (values.hasNext()) {
                    int keysComparison = keysIt.next().compareTo(otherKeysIt.next());
                    int valuesComparison = values.next().compareTo(otherVals.next());
                    if (keysComparison != 0) {
                        result = keysComparison;
                        break;
                    }
                    if (valuesComparison == 0) continue;
                    result = valuesComparison;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    final boolean isEmpty() {
        return this.keys().isEmpty();
    }
}

