/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class FirstCommentFound
implements YamlLines {
    private final YamlLines lines;
    private final boolean documentComment;

    FirstCommentFound(YamlLines lines) {
        this(lines, false);
    }

    FirstCommentFound(YamlLines lines, boolean documentComment) {
        this.lines = lines;
        this.documentComment = documentComment;
    }

    @Override
    public Iterator<YamlLine> iterator() {
        Iterator<YamlLine> iterator = this.documentComment ? this.documentComment() : this.nodeComment();
        return iterator;
    }

    @Override
    public Collection<YamlLine> original() {
        return this.lines.original();
    }

    @Override
    public YamlNode toYamlNode(YamlLine prev, boolean guessIndentation) {
        return this.lines.toYamlNode(prev, guessIndentation);
    }

    private Iterator<YamlLine> nodeComment() {
        Iterator<YamlLine> iterator = this.lines.iterator();
        ArrayList<YamlLine> comment = new ArrayList<YamlLine>();
        while (iterator.hasNext()) {
            boolean notYamlStart;
            YamlLine line = iterator.next();
            boolean hasComment = !line.comment().isEmpty();
            boolean bl = notYamlStart = !"---".equals(line.trimmed());
            if (!notYamlStart || !hasComment) break;
            if (!line.trimmed().startsWith("#")) continue;
            comment.add(line);
        }
        iterator = comment.iterator();
        return iterator;
    }

    private Iterator<YamlLine> documentComment() {
        ArrayList<YamlLine> comment = new ArrayList<YamlLine>();
        Iterator<YamlLine> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            YamlLine line = iterator.next();
            if ("---".equals(line.trimmed())) {
                while (iterator.hasNext() && !(line = iterator.next()).comment().isEmpty()) {
                    if (!line.trimmed().startsWith("#")) continue;
                    comment.add(line);
                }
            }
            if (comment.size() <= 0) continue;
            break;
        }
        iterator = comment.iterator();
        return iterator;
    }
}

