/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.AllYamlLines;
import com.amihaiemil.eoyaml.BaseScalar;
import com.amihaiemil.eoyaml.BuiltComment;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.ReadComment;
import com.amihaiemil.eoyaml.Skip;
import com.amihaiemil.eoyaml.YamlLine;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ReadPlainScalar
extends BaseScalar {
    private static final Pattern QUOTED_LITERAL_MAP_SEQ = Pattern.compile("^([ ]*(-[ ]+)(('(?:[^'\\\\]|\\\\.)*')|(\"(?:[^\"\\\\]|\\\\.)*\"))|(.*:[ ]+(.*))|(-[ ]+(.*)))$");
    private static final int QUOTED_LITERAL_GROUP = 3;
    private static final int MAPPING_GROUP = 7;
    private static final int SEQUENCE_GROUP = 9;
    private final AllYamlLines all;
    private final YamlLine scalar;

    ReadPlainScalar(AllYamlLines all, YamlLine scalar) {
        this.all = all;
        this.scalar = scalar;
    }

    @Override
    public String value() {
        String value = this.scalar.trimmed();
        Matcher matcher = this.escapedSequenceScalar(this.scalar);
        if (matcher.matches()) {
            if (matcher.group(3) != null) {
                value = matcher.group(3);
            } else if (matcher.group(7) != null) {
                value = matcher.group(7).trim();
            } else if (matcher.group(9) != null) {
                value = matcher.group(9).trim();
            }
        }
        if ("null".equals(value)) {
            return null;
        }
        return this.unescape(value);
    }

    @Override
    public Comment comment() {
        Comment comment = this.scalar instanceof YamlLine.NullYamlLine ? new BuiltComment(this, "") : new ReadComment(new Skip(this.all, line -> line.number() != this.scalar.number()), this);
        return comment;
    }

    private String unescape(String value) {
        String unescaped = value == null || value.length() <= 2 ? value : (value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : (value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value));
        return unescaped;
    }

    private Matcher escapedSequenceScalar(YamlLine dashLine) {
        String trimmed = dashLine.trimmed();
        return QUOTED_LITERAL_MAP_SEQ.matcher(trimmed);
    }
}

