/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.AllYamlLines;
import com.amihaiemil.eoyaml.Backwards;
import com.amihaiemil.eoyaml.BaseYamlMapping;
import com.amihaiemil.eoyaml.BaseYamlNode;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.EmptyYamlMapping;
import com.amihaiemil.eoyaml.EmptyYamlSequence;
import com.amihaiemil.eoyaml.FirstCommentFound;
import com.amihaiemil.eoyaml.PlainStringScalar;
import com.amihaiemil.eoyaml.ReadComment;
import com.amihaiemil.eoyaml.ReadPlainScalar;
import com.amihaiemil.eoyaml.ReadYamlSequence;
import com.amihaiemil.eoyaml.SameIndentationLevel;
import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.Skip;
import com.amihaiemil.eoyaml.WellIndented;
import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import com.amihaiemil.eoyaml.YamlNode;
import com.amihaiemil.eoyaml.exceptions.YamlReadingException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

final class ReadYamlMapping
extends BaseYamlMapping {
    private YamlLine previous;
    private final AllYamlLines all;
    private final YamlLines significant;
    private final boolean guessIndentation;
    private final int commentStop;

    ReadYamlMapping(AllYamlLines lines) {
        this(lines, Boolean.FALSE);
    }

    ReadYamlMapping(AllYamlLines lines, boolean guessIndentation) {
        this(-1, new YamlLine.NullYamlLine(), lines, guessIndentation);
    }

    ReadYamlMapping(int commentStop, YamlLine previous, AllYamlLines lines, boolean guessIndentation) {
        this.commentStop = commentStop;
        this.previous = previous;
        this.all = lines;
        this.significant = new SameIndentationLevel(new WellIndented(new Skip(lines, line -> line.number() <= previous.number(), line -> line.trimmed().startsWith("#"), line -> line.trimmed().startsWith("---"), line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!")), guessIndentation));
        this.guessIndentation = guessIndentation;
    }

    @Override
    public Set<YamlNode> keys() {
        LinkedHashSet<YamlNode> keys = new LinkedHashSet<YamlNode>();
        YamlLine prev = new YamlLine.NullYamlLine();
        for (YamlLine line : this.significant) {
            String trimmed = line.trimmed();
            if (trimmed.startsWith(":") || trimmed.startsWith("-") && !(prev instanceof YamlLine.NullYamlLine)) continue;
            if ("?".equals(trimmed)) {
                keys.add(this.significant.toYamlNode(line, this.guessIndentation));
            } else {
                if (!trimmed.contains(":")) continue;
                String key = trimmed.startsWith("-") ? trimmed.substring(1, trimmed.indexOf(":")).trim() : trimmed.substring(0, trimmed.indexOf(":")).trim();
                if (!key.isEmpty()) {
                    keys.add(new PlainStringScalar(key));
                }
            }
            prev = line;
        }
        return keys;
    }

    @Override
    public YamlNode value(YamlNode key) {
        YamlNode value = key instanceof Scalar ? this.valueOfStringKey(((Scalar)key).value()) : this.valueOfNodeKey(key);
        return value;
    }

    @Override
    public Comment comment() {
        boolean documentComment = this.previous.number() < 0;
        return new ReadComment(new Backwards(new FirstCommentFound(new Backwards(new Skip(this.all, line -> {
            boolean skip = documentComment ? (this.significant.iterator().hasNext() ? line.number() >= this.significant.iterator().next().number() : false) : line.number() >= this.commentStop;
            return skip;
        }, line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!"))), documentComment)), this);
    }

    private YamlNode valueOfStringKey(String key) {
        String[] keys;
        YamlNode value = null;
        for (String tryKey : keys = new String[]{key, "\"" + key + "\"", "'" + key + "'"}) {
            for (YamlLine line : this.significant) {
                String trimmed = line.trimmed();
                if (trimmed.matches("^-?[ ]*" + Pattern.quote(tryKey) + ":") || trimmed.matches("^" + Pattern.quote(tryKey) + "\\:[ ]*\\>$") || trimmed.matches("^" + Pattern.quote(tryKey) + "\\:[ ]*\\|$")) {
                    value = this.significant.toYamlNode(line, this.guessIndentation);
                } else if (trimmed.matches(tryKey + ":[ ]*\\{}")) {
                    value = new EmptyYamlMapping(new ReadYamlMapping(line.number(), this.all.line(line.number()), this.all, this.guessIndentation));
                } else if (trimmed.matches(tryKey + ":[ ]*\\[]")) {
                    value = new EmptyYamlSequence(new ReadYamlSequence(this.all.line(line.number()), this.all, this.guessIndentation));
                } else if ((trimmed.startsWith(tryKey + ":") || trimmed.startsWith("- " + tryKey + ":")) && trimmed.length() > 1) {
                    value = new ReadPlainScalar(this.all, line);
                }
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private YamlNode valueOfNodeKey(YamlNode key) {
        YamlNode value = null;
        Iterator<YamlLine> linesIt = this.significant.iterator();
        while (linesIt.hasNext()) {
            YamlNode keyNode;
            YamlLine line = linesIt.next();
            String trimmed = line.trimmed();
            if (!"?".equals(trimmed) || !(keyNode = this.significant.toYamlNode(line, this.guessIndentation)).equals(key)) continue;
            YamlLine colonLine = linesIt.next();
            if (":".equals(colonLine.trimmed()) || colonLine.trimmed().matches("^\\:[ ]*\\>$") || colonLine.trimmed().matches("^\\:[ ]*\\|$")) {
                value = this.significant.toYamlNode(colonLine, this.guessIndentation);
                break;
            }
            if (colonLine.trimmed().startsWith(":") && colonLine.trimmed().length() > 1) {
                value = new ReadPlainScalar(this.all, colonLine);
                break;
            }
            throw new YamlReadingException("No value found for existing complex key: " + System.lineSeparator() + ((BaseYamlNode)key).toString());
        }
        return value;
    }
}

