/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.AllYamlLines;
import com.amihaiemil.eoyaml.Backwards;
import com.amihaiemil.eoyaml.BaseYamlSequence;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.EmptyYamlMapping;
import com.amihaiemil.eoyaml.EmptyYamlSequence;
import com.amihaiemil.eoyaml.FirstCommentFound;
import com.amihaiemil.eoyaml.ReadComment;
import com.amihaiemil.eoyaml.ReadPlainScalar;
import com.amihaiemil.eoyaml.ReadYamlMapping;
import com.amihaiemil.eoyaml.SameIndentationLevel;
import com.amihaiemil.eoyaml.Skip;
import com.amihaiemil.eoyaml.WellIndented;
import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.Collection;
import java.util.LinkedList;

final class ReadYamlSequence
extends BaseYamlSequence {
    private final YamlLine previous;
    private final AllYamlLines all;
    private final YamlLines significant;
    private final boolean guessIndentation;

    ReadYamlSequence(AllYamlLines lines) {
        this(lines, false);
    }

    ReadYamlSequence(AllYamlLines lines, boolean guessIndentation) {
        this(new YamlLine.NullYamlLine(), lines, guessIndentation);
    }

    ReadYamlSequence(YamlLine previous, AllYamlLines lines) {
        this(previous, lines, false);
    }

    ReadYamlSequence(YamlLine previous, AllYamlLines lines, boolean guessIndentation) {
        this.previous = previous;
        this.all = lines;
        this.significant = new SameIndentationLevel(new WellIndented(new Skip(lines, line -> line.number() <= previous.number(), line -> line.trimmed().startsWith("#"), line -> line.trimmed().startsWith("---"), line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!")), guessIndentation));
        this.guessIndentation = guessIndentation;
    }

    @Override
    public Collection<YamlNode> values() {
        LinkedList<YamlNode> kids = new LinkedList<YamlNode>();
        boolean foldedSequence = this.previous.trimmed().matches("^.*\\|.*\\-$");
        for (YamlLine line : this.significant) {
            String trimmed = line.trimmed();
            if (!foldedSequence && !trimmed.startsWith("-")) continue;
            if ("-".equals(trimmed) || trimmed.endsWith("|") || trimmed.endsWith(">")) {
                kids.add(this.significant.toYamlNode(line, this.guessIndentation));
                continue;
            }
            if (trimmed.matches("^-[ ]*\\{}")) {
                kids.add(new EmptyYamlMapping(new ReadYamlMapping(line.number(), this.all.line(line.number()), this.all, this.guessIndentation)));
                continue;
            }
            if (trimmed.matches("^-[ ]*\\[]")) {
                kids.add(new EmptyYamlSequence(new ReadYamlSequence(this.all.line(line.number()), this.all, this.guessIndentation)));
                continue;
            }
            if (this.mappingStartsAtDash(line)) {
                kids.add(new ReadYamlMapping(line.number() + 1, this.all.line(line.number() - 1), this.all, this.guessIndentation));
                continue;
            }
            kids.add(new ReadPlainScalar(this.all, line));
        }
        return kids;
    }

    @Override
    public Comment comment() {
        boolean documentComment = this.previous.number() < 0;
        return new ReadComment(new Backwards(new FirstCommentFound(new Backwards(new Skip(this.all, line -> {
            boolean skip = documentComment ? (this.significant.iterator().hasNext() ? line.number() >= this.significant.iterator().next().number() : false) : line.number() >= this.previous.number();
            return skip;
        }, line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!"))), documentComment)), this);
    }

    private boolean mappingStartsAtDash(YamlLine dashLine) {
        String trimmed = dashLine.trimmed();
        boolean escapedScalar = trimmed.matches("^[ ]*\\-[ ]*\".*\"$") || trimmed.matches("^[ ]*\\-[ ]*'.*'$");
        return trimmed.matches("^.*\\-.*\\:.*$") && !escapedScalar;
    }
}

