/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.BaseYamlMapping;
import com.amihaiemil.eoyaml.BaseYamlNode;
import com.amihaiemil.eoyaml.EmptyYamlMapping;
import com.amihaiemil.eoyaml.PlainStringScalar;
import com.amihaiemil.eoyaml.RtYamlMapping;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.LinkedHashMap;
import java.util.Map;

final class RtYamlMappingBuilder
implements YamlMappingBuilder {
    private final Map<YamlNode, YamlNode> pairs;

    RtYamlMappingBuilder() {
        this(new LinkedHashMap<YamlNode, YamlNode>());
    }

    RtYamlMappingBuilder(Map<YamlNode, YamlNode> pairs) {
        this.pairs = pairs;
    }

    @Override
    public YamlMappingBuilder add(String key, String value) {
        return this.add((YamlNode)new PlainStringScalar(key), (YamlNode)new PlainStringScalar(value));
    }

    @Override
    public YamlMappingBuilder add(YamlNode key, String value) {
        return this.add(key, (YamlNode)new PlainStringScalar(value));
    }

    @Override
    public YamlMappingBuilder add(String key, YamlNode value) {
        return this.add((YamlNode)new PlainStringScalar(key), value);
    }

    @Override
    public YamlMappingBuilder add(YamlNode key, YamlNode value) {
        if (key == null || ((BaseYamlNode)key).isEmpty()) {
            throw new IllegalArgumentException("The key in YamlMapping cannot be null or empty!");
        }
        LinkedHashMap<YamlNode, YamlNode> withAdded = new LinkedHashMap<YamlNode, YamlNode>();
        withAdded.putAll(this.pairs);
        withAdded.put(key, value);
        return new RtYamlMappingBuilder(withAdded);
    }

    @Override
    public YamlMapping build(String comment) {
        BaseYamlMapping mapping = new RtYamlMapping(this.pairs, comment);
        if (this.pairs.isEmpty()) {
            mapping = new EmptyYamlMapping(mapping);
        }
        return mapping;
    }
}

