/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.BaseFoldedScalar;
import com.amihaiemil.eoyaml.BaseScalar;
import com.amihaiemil.eoyaml.BuiltComment;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.PlainStringScalar;
import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.YamlScalarBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

final class RtYamlScalarBuilder
implements YamlScalarBuilder {
    private final List<String> lines;

    RtYamlScalarBuilder() {
        this(new LinkedList<String>());
    }

    RtYamlScalarBuilder(List<String> lines) {
        this.lines = lines;
    }

    @Override
    public YamlScalarBuilder addLine(String value) {
        LinkedList<String> all = new LinkedList<String>();
        all.addAll(this.lines);
        all.add(value);
        return new RtYamlScalarBuilder(all);
    }

    @Override
    public Scalar buildPlainScalar(String comment) {
        String plain = this.lines.stream().filter(line -> line != null).map(line -> line.replaceAll(System.lineSeparator(), " ")).collect(Collectors.joining(" "));
        return new PlainStringScalar(plain, comment);
    }

    @Override
    public Scalar buildFoldedBlockScalar(String comment) {
        return new BuiltFoldedBlockScalar(this.lines, comment);
    }

    @Override
    public Scalar buildLiteralBlockScalar(String comment) {
        return new BuiltLiteralBlockScalar(this.lines, comment);
    }

    static class BuiltLiteralBlockScalar
    extends BaseScalar {
        private final Comment comment;
        private final List<String> lines;

        BuiltLiteralBlockScalar(List<String> lines) {
            this(lines, "");
        }

        BuiltLiteralBlockScalar(List<String> lines, String comment) {
            this.lines = lines;
            this.comment = new BuiltComment(this, comment);
        }

        @Override
        public String value() {
            return this.lines.stream().collect(Collectors.joining(System.lineSeparator()));
        }

        @Override
        public Comment comment() {
            return this.comment;
        }
    }

    static class BuiltFoldedBlockScalar
    extends BaseFoldedScalar {
        private final Comment comment;
        private final List<String> lines;

        BuiltFoldedBlockScalar(List<String> lines) {
            this(lines, "");
        }

        BuiltFoldedBlockScalar(List<String> lines, String comment) {
            this.lines = lines;
            this.comment = new BuiltComment(this, comment);
        }

        @Override
        public String value() {
            return this.lines.stream().map(line -> line.replaceAll(System.lineSeparator(), " ")).collect(Collectors.joining(" "));
        }

        @Override
        public Comment comment() {
            return this.comment;
        }

        @Override
        final List<String> unfolded() {
            ArrayList<String> unfolded = new ArrayList<String>();
            unfolded.addAll(this.lines);
            return unfolded;
        }
    }
}

