/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.Indented;
import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import com.amihaiemil.eoyaml.YamlNode;
import com.amihaiemil.eoyaml.exceptions.YamlIndentationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class WellIndented
implements YamlLines {
    private final YamlLines yamlLines;
    private final boolean guessIndentation;

    WellIndented(YamlLines yamlLines) {
        this(yamlLines, false);
    }

    WellIndented(YamlLines yamlLines, boolean guessIndentation) {
        this.yamlLines = yamlLines;
        this.guessIndentation = guessIndentation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<YamlLine> iterator() {
        Iterator<YamlLine> iterator = this.yamlLines.iterator();
        ArrayList<YamlLine> wellIndented = new ArrayList<YamlLine>();
        if (!iterator.hasNext()) return wellIndented.iterator();
        YamlLine previous = iterator.next();
        wellIndented.add(previous);
        while (iterator.hasNext()) {
            YamlLine line = iterator.next();
            if (!(previous instanceof YamlLine.NullYamlLine)) {
                int prevIndent = previous.indentation();
                if (previous.trimmed().matches("^[ ]*\\-.*\\:.*$")) {
                    prevIndent += 2;
                }
                int lineIndent = line.indentation();
                if (previous.requireNestedIndentation()) {
                    if (lineIndent != prevIndent + 2) {
                        if (!this.guessIndentation) throw new YamlIndentationException("Indentation of line " + (line.number() + 1) + " [" + line.trimmed() + "] is not ok. It should be greater than the one of line " + (previous.number() + 1) + " [" + previous.trimmed() + "] by 2 spaces.");
                        line = new Indented(line, prevIndent + 2);
                    }
                } else if (!"---".equals(previous.trimmed()) && lineIndent > prevIndent) {
                    if (!this.guessIndentation) throw new YamlIndentationException("Indentation of line " + (line.number() + 1) + " [" + line.trimmed() + "] is greater than the one of line " + (previous.number() + 1) + " [" + previous.trimmed() + "]. It should be less or equal.");
                    line = new Indented(line, prevIndent);
                }
            }
            previous = line;
            wellIndented.add(line);
        }
        return wellIndented.iterator();
    }

    @Override
    public Collection<YamlLine> original() {
        return this.yamlLines.original();
    }

    @Override
    public YamlNode toYamlNode(YamlLine prev, boolean guessIndent) {
        return this.yamlLines.toYamlNode(prev, guessIndent);
    }
}

