/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml.extensions;

import com.amihaiemil.eoyaml.BaseYamlMapping;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.Set;
import java.util.function.Supplier;

public final class MergedYamlMapping
extends BaseYamlMapping {
    private YamlMapping merged;

    public MergedYamlMapping(YamlMapping original, YamlMapping changed) {
        this(original, changed, false);
    }

    public MergedYamlMapping(YamlMapping original, Supplier<YamlMapping> changed) {
        this(original, changed, false);
    }

    public MergedYamlMapping(YamlMapping original, Supplier<YamlMapping> changed, boolean overrideConflicts) {
        this(original, changed.get(), overrideConflicts);
    }

    public MergedYamlMapping(YamlMapping original, YamlMapping changed, boolean overrideConflicts) {
        if (original == null && changed == null) {
            throw new IllegalArgumentException("Both mappings cannot be null!");
        }
        this.merged = MergedYamlMapping.merge(original, changed, overrideConflicts);
    }

    @Override
    public Set<YamlNode> keys() {
        return this.merged.keys();
    }

    @Override
    public YamlNode value(YamlNode key) {
        return this.merged.value(key);
    }

    @Override
    public Comment comment() {
        return this.merged.comment();
    }

    private static YamlMapping merge(YamlMapping original, YamlMapping changed, boolean overrideConflicts) {
        YamlMapping merged;
        if (original == null || original.keys().isEmpty()) {
            merged = changed;
        } else if (changed == null || changed.keys().isEmpty()) {
            merged = original;
        } else {
            YamlMappingBuilder builder = Yaml.createYamlMappingBuilder();
            Set<YamlNode> changedKeys = changed.keys();
            for (YamlNode key : original.keys()) {
                if (changedKeys.contains(key)) {
                    builder = overrideConflicts ? builder.add(key, changed.value(key)) : builder.add(key, original.value(key));
                    changedKeys.remove(key);
                    continue;
                }
                builder = builder.add(key, original.value(key));
            }
            for (YamlNode key : changedKeys) {
                builder = builder.add(key, changed.value(key));
            }
            merged = builder.build(original.comment().value());
        }
        return merged;
    }
}

