/*
 * Decompiled with CFR 0.152.
 */
package com.arronlong.httpclientutil.common;

import com.arronlong.httpclientutil.common.HttpMethods;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.protocol.HttpContext;

public class HttpConfig {
    private HttpClient client;
    private Header[] headers;
    private boolean isReturnRespHeaders;
    private HttpMethods method = HttpMethods.GET;
    private String methodName;
    private HttpContext context;
    private String json;
    private String encoding = Charset.defaultCharset().displayName();
    private String inenc;
    private String outenc;
    private RequestConfig requestConfig;
    private static final ThreadLocal<OutputStream> outs = new ThreadLocal();
    private static final ThreadLocal<String> urls = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> maps = new ThreadLocal();

    private HttpConfig() {
    }

    public static HttpConfig custom() {
        return new HttpConfig();
    }

    public HttpConfig client(HttpClient client) {
        this.client = client;
        return this;
    }

    public HttpConfig url(String url) {
        urls.set(url);
        return this;
    }

    public HttpConfig headers(Header[] headers) {
        this.headers = headers;
        return this;
    }

    public HttpConfig headers(Header[] headers, boolean isReturnRespHeaders) {
        this.headers = headers;
        this.isReturnRespHeaders = isReturnRespHeaders;
        return this;
    }

    public HttpConfig method(HttpMethods method) {
        this.method = method;
        return this;
    }

    public HttpConfig methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public HttpConfig context(HttpContext context) {
        this.context = context;
        return this;
    }

    public HttpConfig map(Map<String, Object> map) {
        Map<String, Object> m = maps.get();
        if (m == null || m == null || map == null) {
            m = map;
        } else {
            m.putAll(map);
        }
        maps.set(m);
        return this;
    }

    public HttpConfig json(String json) {
        this.json = json;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("$ENTITY_JSON$", json);
        maps.set(map);
        return this;
    }

    public HttpConfig files(String[] filePaths) {
        return this.files(filePaths, "file");
    }

    public HttpConfig files(String[] filePaths, String inputName) {
        return this.files(filePaths, inputName, false);
    }

    public HttpConfig files(String[] filePaths, String inputName, boolean forceRemoveContentTypeChraset) {
        Map<String, Object> m = maps.get();
        if (m == null || m == null) {
            m = new HashMap<String, Object>();
        }
        m.put("$ENTITY_MULTIPART$", filePaths);
        m.put("$ENTITY_MULTIPART$.name", inputName);
        m.put("$ENTITY_MULTIPART$.rmCharset", forceRemoveContentTypeChraset);
        maps.set(m);
        return this;
    }

    public HttpConfig encoding(String encoding) {
        this.inenc(encoding);
        this.outenc(encoding);
        this.encoding = encoding;
        return this;
    }

    public HttpConfig inenc(String inenc) {
        this.inenc = inenc;
        return this;
    }

    public HttpConfig outenc(String outenc) {
        this.outenc = outenc;
        return this;
    }

    public HttpConfig out(OutputStream out) {
        outs.set(out);
        return this;
    }

    public HttpConfig timeout(int timeout) {
        return this.timeout(timeout, true);
    }

    public HttpConfig timeout(int timeout, boolean redirectEnable) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(redirectEnable).build();
        return this.timeout(config);
    }

    public HttpConfig timeout(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public HttpClient client() {
        return this.client;
    }

    public Header[] headers() {
        return this.headers;
    }

    public boolean isReturnRespHeaders() {
        return this.isReturnRespHeaders;
    }

    public String url() {
        return urls.get();
    }

    public HttpMethods method() {
        return this.method;
    }

    public String methodName() {
        return this.methodName;
    }

    public HttpContext context() {
        return this.context;
    }

    public Map<String, Object> map() {
        return maps.get();
    }

    public String json() {
        return this.json;
    }

    public String encoding() {
        return this.encoding;
    }

    public String inenc() {
        return this.inenc == null ? this.encoding : this.inenc;
    }

    public String outenc() {
        return this.outenc == null ? this.encoding : this.outenc;
    }

    public OutputStream out() {
        return outs.get();
    }

    public RequestConfig requestConfig() {
        return this.requestConfig;
    }
}

