/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.parser.logicdelete;

import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.plugins.parser.logicdelete.LogicDeleteHandler;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;

public class LogicDeleteDefaultHandler
implements LogicDeleteHandler {
    private static final Map<String, TableFieldInfo> tableLogicDeleteMap = new ConcurrentHashMap<String, TableFieldInfo>();

    public LogicDeleteDefaultHandler() {
        this.init();
    }

    private void init() {
        if (tableLogicDeleteMap.isEmpty()) {
            List tableInfos = TableInfoHelper.getTableInfos();
            block0: for (TableInfo tableInfo : tableInfos) {
                List tableFieldInfos = tableInfo.getFieldList();
                for (TableFieldInfo tableFieldInfo : tableFieldInfos) {
                    if (!tableFieldInfo.isLogicDelete()) continue;
                    tableLogicDeleteMap.put(tableInfo.getTableName(), tableFieldInfo);
                    continue block0;
                }
            }
        }
    }

    @Override
    public Expression getValue(String tableName) {
        this.init();
        if (String.class.equals((Object)tableLogicDeleteMap.get(tableName).getPropertyType())) {
            return new StringValue(tableLogicDeleteMap.get(tableName).getLogicNotDeleteValue());
        }
        return new LongValue(tableLogicDeleteMap.get(tableName).getLogicNotDeleteValue());
    }

    @Override
    public String getColumn(String tableName) {
        this.init();
        return tableLogicDeleteMap.get(tableName).getColumn();
    }

    @Override
    public boolean doTableFilter(String tableName) {
        this.init();
        return !tableLogicDeleteMap.containsKey(tableName);
    }
}

