/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.AutoMappingUnknownColumnBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis-plus")
public class MybatisPlusProperties {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String configLocation;
    private String[] mapperLocations = new String[]{"classpath*:/mapper/**/*.xml"};
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private Properties configurationProperties;
    private CoreConfiguration configuration;
    @Deprecated
    private String typeEnumsPackage;
    @NestedConfigurationProperty
    private GlobalConfig globalConfig = GlobalConfigUtils.defaults();

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of(Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
        return this.defaultScriptingLanguageDriver;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public CoreConfiguration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public String getTypeEnumsPackage() {
        return this.typeEnumsPackage;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public MybatisPlusProperties setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public MybatisPlusProperties setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
        return this;
    }

    public MybatisPlusProperties setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
        return this;
    }

    public MybatisPlusProperties setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
        return this;
    }

    public MybatisPlusProperties setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
        return this;
    }

    public MybatisPlusProperties setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
        return this;
    }

    public MybatisPlusProperties setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
        return this;
    }

    public MybatisPlusProperties setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
        this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
        return this;
    }

    public MybatisPlusProperties setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        return this;
    }

    public MybatisPlusProperties setConfiguration(CoreConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Deprecated
    public MybatisPlusProperties setTypeEnumsPackage(String typeEnumsPackage) {
        this.typeEnumsPackage = typeEnumsPackage;
        return this;
    }

    public MybatisPlusProperties setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MybatisPlusProperties)) {
            return false;
        }
        MybatisPlusProperties other = (MybatisPlusProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckConfigLocation() != other.isCheckConfigLocation()) {
            return false;
        }
        String this$configLocation = this.getConfigLocation();
        String other$configLocation = other.getConfigLocation();
        if (this$configLocation == null ? other$configLocation != null : !this$configLocation.equals(other$configLocation)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMapperLocations(), other.getMapperLocations())) {
            return false;
        }
        String this$typeAliasesPackage = this.getTypeAliasesPackage();
        String other$typeAliasesPackage = other.getTypeAliasesPackage();
        if (this$typeAliasesPackage == null ? other$typeAliasesPackage != null : !this$typeAliasesPackage.equals(other$typeAliasesPackage)) {
            return false;
        }
        Class<?> this$typeAliasesSuperType = this.getTypeAliasesSuperType();
        Class<?> other$typeAliasesSuperType = other.getTypeAliasesSuperType();
        if (this$typeAliasesSuperType == null ? other$typeAliasesSuperType != null : !this$typeAliasesSuperType.equals(other$typeAliasesSuperType)) {
            return false;
        }
        String this$typeHandlersPackage = this.getTypeHandlersPackage();
        String other$typeHandlersPackage = other.getTypeHandlersPackage();
        if (this$typeHandlersPackage == null ? other$typeHandlersPackage != null : !this$typeHandlersPackage.equals(other$typeHandlersPackage)) {
            return false;
        }
        ExecutorType this$executorType = this.getExecutorType();
        ExecutorType other$executorType = other.getExecutorType();
        if (this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType)) {
            return false;
        }
        Class<? extends LanguageDriver> this$defaultScriptingLanguageDriver = this.getDefaultScriptingLanguageDriver();
        Class<? extends LanguageDriver> other$defaultScriptingLanguageDriver = other.getDefaultScriptingLanguageDriver();
        if (this$defaultScriptingLanguageDriver == null ? other$defaultScriptingLanguageDriver != null : !this$defaultScriptingLanguageDriver.equals(other$defaultScriptingLanguageDriver)) {
            return false;
        }
        Properties this$configurationProperties = this.getConfigurationProperties();
        Properties other$configurationProperties = other.getConfigurationProperties();
        if (this$configurationProperties == null ? other$configurationProperties != null : !((Object)this$configurationProperties).equals(other$configurationProperties)) {
            return false;
        }
        CoreConfiguration this$configuration = this.getConfiguration();
        CoreConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$typeEnumsPackage = this.getTypeEnumsPackage();
        String other$typeEnumsPackage = other.getTypeEnumsPackage();
        if (this$typeEnumsPackage == null ? other$typeEnumsPackage != null : !this$typeEnumsPackage.equals(other$typeEnumsPackage)) {
            return false;
        }
        GlobalConfig this$globalConfig = this.getGlobalConfig();
        GlobalConfig other$globalConfig = other.getGlobalConfig();
        return !(this$globalConfig == null ? other$globalConfig != null : !this$globalConfig.equals(other$globalConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MybatisPlusProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckConfigLocation() ? 79 : 97);
        String $configLocation = this.getConfigLocation();
        result = result * 59 + ($configLocation == null ? 43 : $configLocation.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMapperLocations());
        String $typeAliasesPackage = this.getTypeAliasesPackage();
        result = result * 59 + ($typeAliasesPackage == null ? 43 : $typeAliasesPackage.hashCode());
        Class<?> $typeAliasesSuperType = this.getTypeAliasesSuperType();
        result = result * 59 + ($typeAliasesSuperType == null ? 43 : $typeAliasesSuperType.hashCode());
        String $typeHandlersPackage = this.getTypeHandlersPackage();
        result = result * 59 + ($typeHandlersPackage == null ? 43 : $typeHandlersPackage.hashCode());
        ExecutorType $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        Class<? extends LanguageDriver> $defaultScriptingLanguageDriver = this.getDefaultScriptingLanguageDriver();
        result = result * 59 + ($defaultScriptingLanguageDriver == null ? 43 : $defaultScriptingLanguageDriver.hashCode());
        Properties $configurationProperties = this.getConfigurationProperties();
        result = result * 59 + ($configurationProperties == null ? 43 : ((Object)$configurationProperties).hashCode());
        CoreConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $typeEnumsPackage = this.getTypeEnumsPackage();
        result = result * 59 + ($typeEnumsPackage == null ? 43 : $typeEnumsPackage.hashCode());
        GlobalConfig $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : $globalConfig.hashCode());
        return result;
    }

    public String toString() {
        return "MybatisPlusProperties(configLocation=" + this.getConfigLocation() + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", typeAliasesSuperType=" + this.getTypeAliasesSuperType() + ", typeHandlersPackage=" + this.getTypeHandlersPackage() + ", checkConfigLocation=" + this.isCheckConfigLocation() + ", executorType=" + this.getExecutorType() + ", defaultScriptingLanguageDriver=" + this.getDefaultScriptingLanguageDriver() + ", configurationProperties=" + this.getConfigurationProperties() + ", configuration=" + this.getConfiguration() + ", typeEnumsPackage=" + this.getTypeEnumsPackage() + ", globalConfig=" + this.getGlobalConfig() + ")";
    }

    public static class CoreConfiguration {
        private Boolean safeRowBoundsEnabled;
        private Boolean safeResultHandlerEnabled;
        private Boolean mapUnderscoreToCamelCase;
        private Boolean aggressiveLazyLoading;
        private Boolean multipleResultSetsEnabled;
        private Boolean useGeneratedKeys;
        private Boolean useColumnLabel;
        private Boolean cacheEnabled;
        private Boolean callSettersOnNulls;
        private Boolean useActualParamName;
        private Boolean returnInstanceForEmptyRow;
        private Boolean shrinkWhitespacesInSql;
        private Boolean nullableOnForEach;
        private Boolean argNameBasedConstructorAutoMapping;
        private Boolean lazyLoadingEnabled;
        private Integer defaultStatementTimeout;
        private Integer defaultFetchSize;
        private LocalCacheScope localCacheScope;
        private JdbcType jdbcTypeForNull;
        private ResultSetType defaultResultSetType;
        private ExecutorType defaultExecutorType;
        private AutoMappingBehavior autoMappingBehavior;
        private AutoMappingUnknownColumnBehavior autoMappingUnknownColumnBehavior;
        private String logPrefix;
        private Set<String> lazyLoadTriggerMethods;
        private Class<? extends Log> logImpl;
        private Class<? extends VFS> vfsImpl;
        private Class<?> defaultSqlProviderType;
        Class<? extends TypeHandler> defaultEnumTypeHandler;
        private Class<?> configurationFactory;
        private Properties variables;
        private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;

        public void applyTo(Configuration target) {
            PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            mapper.from((Object)this.getSafeRowBoundsEnabled()).to(arg_0 -> ((Configuration)target).setSafeRowBoundsEnabled(arg_0));
            mapper.from((Object)this.getSafeResultHandlerEnabled()).to(arg_0 -> ((Configuration)target).setSafeResultHandlerEnabled(arg_0));
            mapper.from((Object)this.getMapUnderscoreToCamelCase()).to(arg_0 -> ((Configuration)target).setMapUnderscoreToCamelCase(arg_0));
            mapper.from((Object)this.getAggressiveLazyLoading()).to(arg_0 -> ((Configuration)target).setAggressiveLazyLoading(arg_0));
            mapper.from((Object)this.getMultipleResultSetsEnabled()).to(arg_0 -> ((Configuration)target).setMultipleResultSetsEnabled(arg_0));
            mapper.from((Object)this.getUseGeneratedKeys()).to(arg_0 -> ((Configuration)target).setUseGeneratedKeys(arg_0));
            mapper.from((Object)this.getUseColumnLabel()).to(arg_0 -> ((Configuration)target).setUseColumnLabel(arg_0));
            mapper.from((Object)this.getCacheEnabled()).to(arg_0 -> ((Configuration)target).setCacheEnabled(arg_0));
            mapper.from((Object)this.getCallSettersOnNulls()).to(arg_0 -> ((Configuration)target).setCallSettersOnNulls(arg_0));
            mapper.from((Object)this.getUseActualParamName()).to(arg_0 -> ((Configuration)target).setUseActualParamName(arg_0));
            mapper.from((Object)this.getReturnInstanceForEmptyRow()).to(arg_0 -> ((Configuration)target).setReturnInstanceForEmptyRow(arg_0));
            mapper.from((Object)this.getShrinkWhitespacesInSql()).to(arg_0 -> ((Configuration)target).setShrinkWhitespacesInSql(arg_0));
            mapper.from((Object)this.getNullableOnForEach()).to(arg_0 -> ((Configuration)target).setNullableOnForEach(arg_0));
            mapper.from((Object)this.getArgNameBasedConstructorAutoMapping()).to(arg_0 -> ((Configuration)target).setArgNameBasedConstructorAutoMapping(arg_0));
            mapper.from((Object)this.getLazyLoadingEnabled()).to(arg_0 -> ((Configuration)target).setLazyLoadingEnabled(arg_0));
            mapper.from((Object)this.getLogPrefix()).to(arg_0 -> ((Configuration)target).setLogPrefix(arg_0));
            mapper.from(this.getLazyLoadTriggerMethods()).to(arg_0 -> ((Configuration)target).setLazyLoadTriggerMethods(arg_0));
            mapper.from((Object)this.getDefaultStatementTimeout()).to(arg_0 -> ((Configuration)target).setDefaultStatementTimeout(arg_0));
            mapper.from((Object)this.getDefaultFetchSize()).to(arg_0 -> ((Configuration)target).setDefaultFetchSize(arg_0));
            mapper.from((Object)this.getLocalCacheScope()).to(arg_0 -> ((Configuration)target).setLocalCacheScope(arg_0));
            mapper.from((Object)this.getJdbcTypeForNull()).to(arg_0 -> ((Configuration)target).setJdbcTypeForNull(arg_0));
            mapper.from((Object)this.getDefaultResultSetType()).to(arg_0 -> ((Configuration)target).setDefaultResultSetType(arg_0));
            mapper.from((Object)this.getDefaultExecutorType()).to(arg_0 -> ((Configuration)target).setDefaultExecutorType(arg_0));
            mapper.from((Object)this.getAutoMappingBehavior()).to(arg_0 -> ((Configuration)target).setAutoMappingBehavior(arg_0));
            mapper.from((Object)this.getAutoMappingUnknownColumnBehavior()).to(arg_0 -> ((Configuration)target).setAutoMappingUnknownColumnBehavior(arg_0));
            mapper.from((Object)this.getVariables()).to(arg_0 -> ((Configuration)target).setVariables(arg_0));
            mapper.from(this.getLogImpl()).to(arg_0 -> ((Configuration)target).setLogImpl(arg_0));
            mapper.from(this.getVfsImpl()).to(arg_0 -> ((Configuration)target).setVfsImpl(arg_0));
            mapper.from(this.getDefaultSqlProviderType()).to(arg_0 -> ((Configuration)target).setDefaultSqlProviderType(arg_0));
            mapper.from(this.getConfigurationFactory()).to(arg_0 -> ((Configuration)target).setConfigurationFactory(arg_0));
            mapper.from(this.getDefaultEnumTypeHandler()).to(arg_0 -> ((Configuration)target).setDefaultEnumTypeHandler(arg_0));
            mapper.from(this.getDefaultScriptingLanguageDriver()).to(arg_0 -> ((Configuration)target).setDefaultScriptingLanguage(arg_0));
        }

        public Boolean getSafeRowBoundsEnabled() {
            return this.safeRowBoundsEnabled;
        }

        public Boolean getSafeResultHandlerEnabled() {
            return this.safeResultHandlerEnabled;
        }

        public Boolean getMapUnderscoreToCamelCase() {
            return this.mapUnderscoreToCamelCase;
        }

        public Boolean getAggressiveLazyLoading() {
            return this.aggressiveLazyLoading;
        }

        public Boolean getMultipleResultSetsEnabled() {
            return this.multipleResultSetsEnabled;
        }

        public Boolean getUseGeneratedKeys() {
            return this.useGeneratedKeys;
        }

        public Boolean getUseColumnLabel() {
            return this.useColumnLabel;
        }

        public Boolean getCacheEnabled() {
            return this.cacheEnabled;
        }

        public Boolean getCallSettersOnNulls() {
            return this.callSettersOnNulls;
        }

        public Boolean getUseActualParamName() {
            return this.useActualParamName;
        }

        public Boolean getReturnInstanceForEmptyRow() {
            return this.returnInstanceForEmptyRow;
        }

        public Boolean getShrinkWhitespacesInSql() {
            return this.shrinkWhitespacesInSql;
        }

        public Boolean getNullableOnForEach() {
            return this.nullableOnForEach;
        }

        public Boolean getArgNameBasedConstructorAutoMapping() {
            return this.argNameBasedConstructorAutoMapping;
        }

        public Boolean getLazyLoadingEnabled() {
            return this.lazyLoadingEnabled;
        }

        public Integer getDefaultStatementTimeout() {
            return this.defaultStatementTimeout;
        }

        public Integer getDefaultFetchSize() {
            return this.defaultFetchSize;
        }

        public LocalCacheScope getLocalCacheScope() {
            return this.localCacheScope;
        }

        public JdbcType getJdbcTypeForNull() {
            return this.jdbcTypeForNull;
        }

        public ResultSetType getDefaultResultSetType() {
            return this.defaultResultSetType;
        }

        public ExecutorType getDefaultExecutorType() {
            return this.defaultExecutorType;
        }

        public AutoMappingBehavior getAutoMappingBehavior() {
            return this.autoMappingBehavior;
        }

        public AutoMappingUnknownColumnBehavior getAutoMappingUnknownColumnBehavior() {
            return this.autoMappingUnknownColumnBehavior;
        }

        public String getLogPrefix() {
            return this.logPrefix;
        }

        public Set<String> getLazyLoadTriggerMethods() {
            return this.lazyLoadTriggerMethods;
        }

        public Class<? extends Log> getLogImpl() {
            return this.logImpl;
        }

        public Class<? extends VFS> getVfsImpl() {
            return this.vfsImpl;
        }

        public Class<?> getDefaultSqlProviderType() {
            return this.defaultSqlProviderType;
        }

        public Class<? extends TypeHandler> getDefaultEnumTypeHandler() {
            return this.defaultEnumTypeHandler;
        }

        public Class<?> getConfigurationFactory() {
            return this.configurationFactory;
        }

        public Properties getVariables() {
            return this.variables;
        }

        public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
            return this.defaultScriptingLanguageDriver;
        }

        public CoreConfiguration setSafeRowBoundsEnabled(Boolean safeRowBoundsEnabled) {
            this.safeRowBoundsEnabled = safeRowBoundsEnabled;
            return this;
        }

        public CoreConfiguration setSafeResultHandlerEnabled(Boolean safeResultHandlerEnabled) {
            this.safeResultHandlerEnabled = safeResultHandlerEnabled;
            return this;
        }

        public CoreConfiguration setMapUnderscoreToCamelCase(Boolean mapUnderscoreToCamelCase) {
            this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
            return this;
        }

        public CoreConfiguration setAggressiveLazyLoading(Boolean aggressiveLazyLoading) {
            this.aggressiveLazyLoading = aggressiveLazyLoading;
            return this;
        }

        public CoreConfiguration setMultipleResultSetsEnabled(Boolean multipleResultSetsEnabled) {
            this.multipleResultSetsEnabled = multipleResultSetsEnabled;
            return this;
        }

        public CoreConfiguration setUseGeneratedKeys(Boolean useGeneratedKeys) {
            this.useGeneratedKeys = useGeneratedKeys;
            return this;
        }

        public CoreConfiguration setUseColumnLabel(Boolean useColumnLabel) {
            this.useColumnLabel = useColumnLabel;
            return this;
        }

        public CoreConfiguration setCacheEnabled(Boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
            return this;
        }

        public CoreConfiguration setCallSettersOnNulls(Boolean callSettersOnNulls) {
            this.callSettersOnNulls = callSettersOnNulls;
            return this;
        }

        public CoreConfiguration setUseActualParamName(Boolean useActualParamName) {
            this.useActualParamName = useActualParamName;
            return this;
        }

        public CoreConfiguration setReturnInstanceForEmptyRow(Boolean returnInstanceForEmptyRow) {
            this.returnInstanceForEmptyRow = returnInstanceForEmptyRow;
            return this;
        }

        public CoreConfiguration setShrinkWhitespacesInSql(Boolean shrinkWhitespacesInSql) {
            this.shrinkWhitespacesInSql = shrinkWhitespacesInSql;
            return this;
        }

        public CoreConfiguration setNullableOnForEach(Boolean nullableOnForEach) {
            this.nullableOnForEach = nullableOnForEach;
            return this;
        }

        public CoreConfiguration setArgNameBasedConstructorAutoMapping(Boolean argNameBasedConstructorAutoMapping) {
            this.argNameBasedConstructorAutoMapping = argNameBasedConstructorAutoMapping;
            return this;
        }

        public CoreConfiguration setLazyLoadingEnabled(Boolean lazyLoadingEnabled) {
            this.lazyLoadingEnabled = lazyLoadingEnabled;
            return this;
        }

        public CoreConfiguration setDefaultStatementTimeout(Integer defaultStatementTimeout) {
            this.defaultStatementTimeout = defaultStatementTimeout;
            return this;
        }

        public CoreConfiguration setDefaultFetchSize(Integer defaultFetchSize) {
            this.defaultFetchSize = defaultFetchSize;
            return this;
        }

        public CoreConfiguration setLocalCacheScope(LocalCacheScope localCacheScope) {
            this.localCacheScope = localCacheScope;
            return this;
        }

        public CoreConfiguration setJdbcTypeForNull(JdbcType jdbcTypeForNull) {
            this.jdbcTypeForNull = jdbcTypeForNull;
            return this;
        }

        public CoreConfiguration setDefaultResultSetType(ResultSetType defaultResultSetType) {
            this.defaultResultSetType = defaultResultSetType;
            return this;
        }

        public CoreConfiguration setDefaultExecutorType(ExecutorType defaultExecutorType) {
            this.defaultExecutorType = defaultExecutorType;
            return this;
        }

        public CoreConfiguration setAutoMappingBehavior(AutoMappingBehavior autoMappingBehavior) {
            this.autoMappingBehavior = autoMappingBehavior;
            return this;
        }

        public CoreConfiguration setAutoMappingUnknownColumnBehavior(AutoMappingUnknownColumnBehavior autoMappingUnknownColumnBehavior) {
            this.autoMappingUnknownColumnBehavior = autoMappingUnknownColumnBehavior;
            return this;
        }

        public CoreConfiguration setLogPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
            return this;
        }

        public CoreConfiguration setLazyLoadTriggerMethods(Set<String> lazyLoadTriggerMethods) {
            this.lazyLoadTriggerMethods = lazyLoadTriggerMethods;
            return this;
        }

        public CoreConfiguration setLogImpl(Class<? extends Log> logImpl) {
            this.logImpl = logImpl;
            return this;
        }

        public CoreConfiguration setVfsImpl(Class<? extends VFS> vfsImpl) {
            this.vfsImpl = vfsImpl;
            return this;
        }

        public CoreConfiguration setDefaultSqlProviderType(Class<?> defaultSqlProviderType) {
            this.defaultSqlProviderType = defaultSqlProviderType;
            return this;
        }

        public CoreConfiguration setDefaultEnumTypeHandler(Class<? extends TypeHandler> defaultEnumTypeHandler) {
            this.defaultEnumTypeHandler = defaultEnumTypeHandler;
            return this;
        }

        public CoreConfiguration setConfigurationFactory(Class<?> configurationFactory) {
            this.configurationFactory = configurationFactory;
            return this;
        }

        public CoreConfiguration setVariables(Properties variables) {
            this.variables = variables;
            return this;
        }

        public CoreConfiguration setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
            this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
            return this;
        }
    }
}

