package com.bitkernel.stream.rapid;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Representation of a live stream.
 */
public final class RapidAgentLiveUri extends RapidAgentUri {
    /**
     * Constructs a new instance
     *
     * @param streamId the stream id
     */
    public RapidAgentLiveUri(@NonNull String streamId) {
        this(streamId, null);
    }

    /**
     * Constructs a new instance
     *
     * @param streamId   the stream id
     * @param streamName the stream name
     */
    public RapidAgentLiveUri(@NonNull String streamId, @Nullable String streamName) {
        this(streamId, streamName, null);
    }

    /**
     * Constructs a new instance
     *
     * @param streamId   the stream id
     * @param streamName the stream name
     * @param routeId    the special info for back-to-resource
     */
    public RapidAgentLiveUri(@NonNull String streamId, @Nullable String streamName, @Nullable String routeId) {
        super(streamId);
        if (!TextUtils.isEmpty(streamName)) {
            this.streamName = streamName;
        } else {
            this.streamName = streamId;
        }
        this.setRouteId(routeId);
    }

    @Override
    public RapidAgentUri copySelf() {
        RapidAgentLiveUri other = new RapidAgentLiveUri(streamId, streamName);
        copySelf(other);
        return other;
    }

    @NonNull
    @Override
    public String toString() {
        return "RapidAgentLiveUri{" +
                "streamId='" + streamId + '\'' +
                ", streamName='" + streamName + '\'' +
                ", drmType='" + drmType + '\'' +
                ", abr='" + isAdaptiveBitrate + '\'' +
                ", mb='" + isMicroBlock + '\'' +
                ", mbLevel='" + microBlockLevel + '\'' +
                ", routeId='" + routeId + '\'' +
                ", customInfo='" + customInfo + '\'' +
                '}';
    }
}
