package com.bitkernel.stream.rapid.server;

import android.text.TextUtils;

import com.bitkernel.stream.rapid.RapidAgentConstant;
import com.bitkernel.stream.rapid.utils.AES;
import com.bitkernel.stream.rapid.utils.LogUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class GatewayServer {
    private static final String REQUEST_URL = "/rapid/gateway/request/v1";
    private static final String UPDATE_URL = "/rapid/gateway/update/v1";

    private static volatile GatewayServer sInstance;
    private static String hostUrl;

    public static GatewayServer getInstance() {
        if (sInstance == null) {
            synchronized (GatewayServer.class) {
                if (sInstance == null) {
                    sInstance = new GatewayServer();
                }
            }
        }
        return sInstance;
    }

    private GatewayServer() {
    }

    public void init(String url) {
        hostUrl = url;
    }

    private String postToServer(String url, String clearParams) throws IOException {
        String encryptedParams = encrypt(clearParams);
        String sign = sign(encryptedParams);
        String token = RapidAgentConstant.getToken();
        String version = "1";

        String body = String.format("m=%s&s=%s&t=%s&v=%s",
                URLEncoder.encode(encryptedParams, "UTF-8"),
                URLEncoder.encode(sign, "UTF-8"),
                URLEncoder.encode(token, "UTF-8"),
                URLEncoder.encode(version, "UTF-8"));
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");

        String decryptResponse = HttpEntrance.post(url, headers, body);
        if (!TextUtils.isEmpty(decryptResponse)) {
            try {
                String clearResponse = decrypt(decryptResponse);
                LogUtil.sensitive("after decrypt: " + clearResponse);
                return clearResponse;
            } catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private String sign(String params) {
        return HmacSHA1.encrypt(params, RapidAgentConstant.getSecretKey());
    }

    private String encrypt(String clearParams) {
        return AES.encrypt(clearParams, RapidAgentConstant.getSecretKey());
    }

    private String decrypt(String json) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        if (!jsonObject.has("result")) {
            return json;
        }
        String result = jsonObject.getString("result");
        if (TextUtils.isEmpty(result) || TextUtils.equals(result, "null")) {
            return json;
        }
        String clearResult = AES.decrypt(result, RapidAgentConstant.getSecretKey());
        jsonObject.put("result", clearResult);
        return jsonObject.toString();
    }

    public String request(String vnoId, String uid, String vnoTag, String deviceId, String brand, String model, String cpuInfo,
                          String appName, int sdkVersion, int playerVersion, int engineVersion, int systemVersion) throws IOException {
        String content = "";
        try {
            content = toJson(vnoId, uid, vnoTag, deviceId, brand, model, cpuInfo, appName,
                    sdkVersion, playerVersion, engineVersion, systemVersion,
                    null, null);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return postToServer(hostUrl + REQUEST_URL, content);
    }

    public String update(String vnoId, String uid, String vnoTag, String deviceId, String brand, String model, String cpuInfo,
                         String appName, int sdkVersion, int playerVersion, int engineVersion, int systemVersion,
                         String checksum, String playToken) throws IOException {
        String content = "";
        try {
            content = toJson(vnoId, uid, vnoTag, deviceId, brand, model, cpuInfo, appName,
                    sdkVersion, playerVersion, engineVersion, systemVersion,
                    checksum, playToken);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return postToServer(hostUrl + UPDATE_URL, content);
    }

    private static String toJson(String vnoId, String uid, String vnoTag, String deviceId, String brand, String model, String cpuInfo,
                                 String appName, int sdkVersion, int playerVersion, int engineVersion, int systemVersion,
                                 String checksum, String playToken) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("vnoId", vnoId);
        jsonObject.put("uid", uid);
        jsonObject.put("tag", vnoTag);
        jsonObject.put("deviceId", deviceId);
        jsonObject.put("brand", brand);
        jsonObject.put("model", model);
        jsonObject.put("cpuInfo", cpuInfo);
        jsonObject.put("appName", appName);
        jsonObject.put("sdkVersion", String.valueOf(sdkVersion));
        jsonObject.put("playerVersion", String.valueOf(playerVersion));
        jsonObject.put("engineVersion", String.valueOf(engineVersion));
        jsonObject.put("systemVersion", String.valueOf(systemVersion));
        if (!TextUtils.isEmpty(checksum) && !TextUtils.isEmpty(playToken)) {
            jsonObject.put("checksum", checksum);
            jsonObject.put("playToken", playToken);
        }
        return jsonObject.toString();
    }
}
