package com.bitkernel.stream.rapid;

import com.bitkernel.stream.rapid.config.ServerConfig;
import com.bitkernel.stream.rapid.server.GatewayServer;

import java.io.IOException;

class RapidAgentServer {
    static void init(String url) {
        GatewayServer.getInstance().init(url);
    }

    static String request() throws IOException {
        return GatewayServer.getInstance().request(
                RapidAgentConstant.getVnoId(),
                RapidAgentConstant.getAccountId(),
                RapidAgentConstant.getVnoTag(),
                RapidAgentConstant.getDeviceId(),
                RapidAgentConstant.getBrand(),
                RapidAgentConstant.getModel(),
                RapidAgentConstant.getCpuName(),
                RapidAgentConstant.getApplicationName(),
                RapidAgentConstant.getSdkVersion(),
                RapidAgentConstant.getPlayerVersion(),
                RapidAgentConstant.getEngineVersion(),
                RapidAgentConstant.getSystemVersion());
    }

    static String update() throws IOException {
        return GatewayServer.getInstance().update(
                RapidAgentConstant.getVnoId(),
                RapidAgentConstant.getAccountId(),
                RapidAgentConstant.getVnoTag(),
                RapidAgentConstant.getDeviceId(),
                RapidAgentConstant.getBrand(),
                RapidAgentConstant.getModel(),
                RapidAgentConstant.getCpuName(),
                RapidAgentConstant.getApplicationName(),
                RapidAgentConstant.getSdkVersion(),
                RapidAgentConstant.getPlayerVersion(),
                RapidAgentConstant.getEngineVersion(),
                RapidAgentConstant.getSystemVersion(),
                ServerConfig.getChecksum());
    }
}
