package com.bitkernel.stream.rapid.player;

import static com.bitkernel.stream.rapid.utils.CommonUtil.getStringOfRoConfig;
import static com.bitkernel.stream.rapid.utils.CommonUtil.parseInt;

import static tv.danmaku.ijk.media.common.abr.DefaultBandwidthMeter.DEFAULT_INITIAL_BITRATE_ESTIMATE;
import static tv.danmaku.ijk.media.common.abr.DefaultBandwidthMeter.DEFAULT_SLIDING_WINDOW_MAX_WEIGHT;
import static tv.danmaku.ijk.media.common.abr.DefaultBandwidthMeter.DEFAULT_SLIDING_WINDOW_PERCENTILE;

import com.bitkernel.stream.rapid.RapidAgentConstant;
import com.bitkernel.stream.rapid.config.CommonConfig;

import org.json.JSONException;
import org.json.JSONObject;

import tv.danmaku.ijk.media.common.abr.BandwidthMeter;
import tv.danmaku.ijk.media.common.abr.DefaultBandwidthMeter;

public class RapidIjkBandwidthMeter implements BandwidthMeter, SegmentDownloadedListener {
    private static final boolean ENABLE_DEBUG = RapidAgentConstant.getApplicationName().equals("com.bitkernel.stream.rapid.demo");

    private final DefaultBandwidthMeter internalBandwidthMeter;
    private final boolean ignoreOutOfOrderBlock;
    private final int outOfOrderLength;
    private long currentBlockId = 0;
    private long currentBandwidth = 0;

    public RapidIjkBandwidthMeter() {
        this(false, 0);
    }

    public RapidIjkBandwidthMeter(boolean ignoreOutOfOrderBlock, int outOfOrderLength) {
        this.internalBandwidthMeter = new DefaultBandwidthMeter(
                DEFAULT_INITIAL_BITRATE_ESTIMATE,
                DEFAULT_SLIDING_WINDOW_MAX_WEIGHT,
                DEFAULT_SLIDING_WINDOW_PERCENTILE,
                CommonConfig.getBandwidthEstimatePercent());
        this.ignoreOutOfOrderBlock = ignoreOutOfOrderBlock;
        this.outOfOrderLength = outOfOrderLength;
    }

    private float getDebugPercentile() {
        String percentileString = getStringOfRoConfig("ijk.debug.bandwidth.percent", "100");
        int percentileValue = parseInt(percentileString, 100);
        return percentileValue / 100f;
    }

    @Override
    public long getBitrateEstimate() {
        float percentile = ENABLE_DEBUG ? getDebugPercentile() : 1.0f;
        currentBandwidth = (long) (internalBandwidthMeter.getBitrateEstimate() * percentile);
        return currentBandwidth;
    }

    @Override
    public void addSample(long sampleBytesTransferred, long sampleElapsedTimeMs) {

    }

    @Override
    public void onSegmentDownloaded(String param) {
        try {
            JSONObject jsonObject = new JSONObject(param);
            if (ignoreOutOfOrderBlock) {
                long blockId = jsonObject.getInt("blockId");
                if (currentBlockId - blockId >= outOfOrderLength) {
                    return;
                }
                currentBlockId = Math.max(currentBlockId, blockId);
            }
            int trackType = jsonObject.getInt("trackType");
            int dataSize = jsonObject.getInt("len");
            int elapsedTimeMs = jsonObject.getInt("useMs");
            if (trackType == 1/*TRACK_TYPE_VIDEO*/ || trackType == 2/*TRACK_TYPE_AUDIO_VIDEO_MIX*/) {
                internalBandwidthMeter.addSample(dataSize, elapsedTimeMs);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentBandwidth() {
        return currentBandwidth;
    }
}
