package com.bitkernel.stream.rapid.config;

import android.text.TextUtils;
import android.util.ArrayMap;

import androidx.annotation.NonNull;

import com.bitkernel.stream.rapid.utils.LogUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ServerAddress {
    private final Map<String, String> defaultPrtMap = new ArrayMap<>();
    private final Map<String, String> turboPrtMap = new ArrayMap<>();
    private final Map<String, String> trackerMap = new ArrayMap<>();
    private String defaultPrt;
    private String turboPrt;
    private String tracker;

    public void setDefaultPrtMap(Map<String, String> map) {
        defaultPrtMap.clear();
        defaultPrtMap.putAll(map);
        defaultPrt = map2String(map);
    }

    public void setTurboPrtMap(Map<String, String> map) {
        turboPrtMap.clear();
        turboPrtMap.putAll(map);
        turboPrt = map2String(map);
    }

    public void setTrackerMap(Map<String, String> map) {
        trackerMap.clear();
        trackerMap.putAll(map);
        tracker = map2String(map);
    }

    private static String map2String(Map<String, String> map) {
        boolean firstItem = true;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (TextUtils.isEmpty(entry.getKey())) {
                continue;
            }
            if (firstItem) {
                builder.append(entry.getKey());
                firstItem = false;
            } else {
                builder.append("-").append(entry.getKey());
            }
        }
        return builder.toString();
    }

    public void setDefaultPrt(String defaultPrt) {
        this.defaultPrt = defaultPrt;
    }

    public String getDefaultPrt() {
        return defaultPrt;
    }

    public void setTurboPrt(String turboPrt) {
        this.turboPrt = turboPrt;
    }

    public String getTurboPrt() {
        return turboPrt;
    }

    public void setTracker(String tracker) {
        this.tracker = tracker;
    }

    public String getTracker() {
        return tracker;
    }

    public String getDefaultPrtServerId(String prt) {
        return defaultPrtMap.get(prt);
    }

    public String getTurboPrtServerId(String prt) {
        return turboPrtMap.get(prt);
    }

    public String getTrackerServerId(String tracker) {
        for (Map.Entry<String, String> entry : trackerMap.entrySet()) {
            String trackerInfo = entry.getKey();
            if (trackerInfo != null && trackerInfo.contains(tracker)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public void copy(ServerAddress other) {
        if (!other.defaultPrtMap.isEmpty()) {
            setDefaultPrtMap(other.defaultPrtMap);
        } else {
            defaultPrt = other.defaultPrt;
        }
        if (!other.turboPrtMap.isEmpty()) {
            setTurboPrtMap(other.turboPrtMap);
        } else {
            turboPrt = other.turboPrt;
        }
        if (!other.trackerMap.isEmpty()) {
            setTrackerMap(other.trackerMap);
        } else {
            tracker = other.tracker;
        }
    }

    @NonNull
    @Override
    public String toString() {
        if (LogUtil.PRINT_SENSITIVE) {
            return "track:" + tracker + " defaultPrt:" + defaultPrt + " turboPrt:" + turboPrt;
        } else {
            List<String> tidList = new ArrayList<>();
            for (Map.Entry<String, String> entry : trackerMap.entrySet()) {
                String name = entry.getValue();
                if (TextUtils.isEmpty(name)) {
                    name = "null";
                }
                tidList.add(name);
            }
            List<String> didList = new ArrayList<>();
            for (Map.Entry<String, String> entry : defaultPrtMap.entrySet()) {
                String name = entry.getValue();
                if (TextUtils.isEmpty(name)) {
                    name = "null";
                }
                didList.add(name);
            }
            List<String> bidList = new ArrayList<>();
            for (Map.Entry<String, String> entry : turboPrtMap.entrySet()) {
                String name = entry.getValue();
                if (TextUtils.isEmpty(name)) {
                    name = "null";
                }
                bidList.add(name);
            }
            return String.format(Locale.US, "track(%d):%s defaultPrt(%d):%s turboPrt(%d):%s", tidList.size(), tidList, didList.size(), didList, bidList.size(), bidList);
        }
    }
}
