package com.bitkernel.stream.rapid.config;

import com.bitkernel.stream.rapid.debug.DebugConfig;
import com.bitkernel.stream.rapid.utils.CommonUtil;
import com.bitkernel.stream.rapid.utils.LogUtil;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class CommonConfig {
    public static final int STATISTIC_LEVEL_INFO = 0;
    public static final int STATISTIC_LEVEL_DEBUG = 1;

    private static final int DEFAULT_SERVER_REFRESH_INTERVAL = 600;
    private static final int DEFAULT_METRIC_REPORT_INTERVAL = 55;
    private static final int DEFAULT_STATUS_EVENT_REPORT_INTERVAL = 108;
    private static final int DEFAULT_ENGINE_STARTUP_TIMEOUT = 40;
    private static final int DEFAULT_PLAYER_STARTUP_TIMEOUT = 30;
    private static final int DEFAULT_TIME_SHIFT_MIN_DELAY = 90;
    private static final int DEFAULT_BANDWIDTH_ESTIMATE_PERCENT = 90;
    private static final int DEFAULT_PLAYER_STARTUP_SLOW = 10;
    private static final int DEFAULT_PCT_FALLBACK = 1;
    private static final int DEFAULT_HTTP_RETRY_TIMES = 3;
    private static final int DEFAULT_HTTP_RETRY_INTERVAL_MS = 1000;
    private static final int DEFAULT_MB_ENABLED = 1;
    private static final int DEFAULT_STATISTIC_LEVEL = STATISTIC_LEVEL_INFO;
    private static final String DEFAULT_CDN_VOD_PROTOCOL = "";

    private static final Map<String, Object> COMMON_OPTIONS = new HashMap<>();

    public static void setCommonOptions(Map<String, Object> map) {
        COMMON_OPTIONS.putAll(map);
        Object logObj = map.get("log");
        if (logObj instanceof JSONObject) {
            DebugConfig.parse((JSONObject) logObj);
        }
    }

    public static int serverRefreshInterval() {
        if (COMMON_OPTIONS.containsKey("SRI")) {
            Object interval = COMMON_OPTIONS.get("SRI");
            return CommonUtil.parseInt(interval, DEFAULT_SERVER_REFRESH_INTERVAL);
        }

        return DEFAULT_SERVER_REFRESH_INTERVAL;
    }

    public static int statusEventReportInterval() {
        if (COMMON_OPTIONS.containsKey("SERI")) {
            Object interval = COMMON_OPTIONS.get("SERI");
            return CommonUtil.parseInt(interval, DEFAULT_STATUS_EVENT_REPORT_INTERVAL);
        }

        return DEFAULT_STATUS_EVENT_REPORT_INTERVAL;
    }

    public static int engineStartupTimeout() {
        if (COMMON_OPTIONS.containsKey("EST")) {
            Object interval = COMMON_OPTIONS.get("EST");
            return CommonUtil.parseInt(interval, DEFAULT_ENGINE_STARTUP_TIMEOUT);
        }

        return DEFAULT_ENGINE_STARTUP_TIMEOUT;
    }

    public static int playerStartupTimeout() {
        if (COMMON_OPTIONS.containsKey("PST")) {
            Object interval = COMMON_OPTIONS.get("PST");
            return CommonUtil.parseInt(interval, DEFAULT_PLAYER_STARTUP_TIMEOUT);
        }

        return DEFAULT_PLAYER_STARTUP_TIMEOUT;
    }

    public static int timeShiftMinDelay() {
        if (COMMON_OPTIONS.containsKey("ts_min_delay")) {
            Object interval = COMMON_OPTIONS.get("ts_min_delay");
            return CommonUtil.parseInt(interval, DEFAULT_TIME_SHIFT_MIN_DELAY);
        }

        return DEFAULT_TIME_SHIFT_MIN_DELAY;
    }

    public static String getMetricServers() {
        if (COMMON_OPTIONS.containsKey("metric_host")) {
            return (String) COMMON_OPTIONS.get("metric_host");
        }

        return null;
    }

    public static int metricReportInterval() {
        if (COMMON_OPTIONS.containsKey("metric_int")) {
            Object interval = COMMON_OPTIONS.get("metric_int");
            return CommonUtil.parseInt(interval, DEFAULT_METRIC_REPORT_INTERVAL);
        }

        return DEFAULT_METRIC_REPORT_INTERVAL;
    }

    public static float getBandwidthEstimatePercent() {
        int percent = DEFAULT_BANDWIDTH_ESTIMATE_PERCENT;
        if (COMMON_OPTIONS.containsKey("BEP")) {
            Object interval = COMMON_OPTIONS.get("BEP");
            percent = CommonUtil.parseInt(interval, DEFAULT_BANDWIDTH_ESTIMATE_PERCENT);
        }

        return percent / 100f;
    }

    public static int getPlayerStartupSlow() {
        int second = DEFAULT_PLAYER_STARTUP_SLOW;
        if (COMMON_OPTIONS.containsKey("PSS")) {
            Object interval = COMMON_OPTIONS.get("PSS");
            second = CommonUtil.parseInt(interval, DEFAULT_PLAYER_STARTUP_SLOW);
        }

        return second * 1000;
    }

    public static String getPctMetricServers() {
        if (COMMON_OPTIONS.containsKey("pct_metric_host")) {
            return (String) COMMON_OPTIONS.get("pct_metric_host");
        }

        return null;
    }

    public static String getPctLogServer() {
        if (COMMON_OPTIONS.containsKey("pct_ls")) {
            return (String) COMMON_OPTIONS.get("pct_ls");
        }

        return null;
    }

    public static boolean getPctFallback() {
        int fallback = DEFAULT_PCT_FALLBACK;
        if (COMMON_OPTIONS.containsKey("pct_fb")) {
            Object obj = COMMON_OPTIONS.get("pct_fb");
            fallback = CommonUtil.parseInt(obj, DEFAULT_PCT_FALLBACK);
        }

        return fallback == 1;
    }

    public static int getHttpRetryTimes() {
        if (COMMON_OPTIONS.containsKey("http_rt")) {
            Object obj = COMMON_OPTIONS.get("http_rt");
            return CommonUtil.parseInt(obj, DEFAULT_HTTP_RETRY_TIMES);
        }

        return DEFAULT_HTTP_RETRY_TIMES;
    }

    public static int getHttpRetryInterval() {
        if (COMMON_OPTIONS.containsKey("http_ri")) {
            Object obj = COMMON_OPTIONS.get("http_ri");
            return CommonUtil.parseInt(obj, DEFAULT_HTTP_RETRY_INTERVAL_MS);
        }

        return DEFAULT_HTTP_RETRY_INTERVAL_MS;
    }

    public static String getPctOpaque() {
        if (COMMON_OPTIONS.containsKey("pct_opaque")) {
            return (String) COMMON_OPTIONS.get("pct_opaque");
        }

        return null;
    }

    public static boolean isMicroBlockEnabled() {
        int enabled = DEFAULT_MB_ENABLED;
        if (COMMON_OPTIONS.containsKey("mb")) {
            Object obj = COMMON_OPTIONS.get("mb");
            enabled = CommonUtil.parseInt(obj, DEFAULT_MB_ENABLED);
        }

        return enabled == 1;
    }

    public static int getStatisticLevel() {
        if (COMMON_OPTIONS.containsKey("metric_lv")) {
            Object obj = COMMON_OPTIONS.get("metric_lv");
            return CommonUtil.parseInt(obj, DEFAULT_STATISTIC_LEVEL);
        }

        return DEFAULT_STATISTIC_LEVEL;
    }

    public static String getCdnVodProtocol() {
        if (COMMON_OPTIONS.containsKey("CVP")) {
            Object obj = COMMON_OPTIONS.get("CVP");
            if (obj instanceof String) {
                return (String) obj;
            }
        }

        return DEFAULT_CDN_VOD_PROTOCOL;
    }

    public static void printConfig() {
        LogUtil.sensitive("common config : " + COMMON_OPTIONS);
    }
}
