package com.bitkernel.stream.rapid.player;

import androidx.annotation.NonNull;

import com.bitkernel.stream.rapid.RapidAgentSource;

import java.util.HashMap;
import java.util.Map;

import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class RapidAgentOpenBuilder extends DefaultPlayerBuilder {
    private final boolean isAdaptiveBitrate;

    public RapidAgentOpenBuilder(@NonNull RapidAgentSource rapidAgentSource) {
        this.isAdaptiveBitrate = rapidAgentSource.isAdaptiveBitrate();
    }

    @Override
    public IMediaPlayer createIjkMediaPlayer() {
        IjkMediaPlayer ijkMediaPlayer = new IjkMediaPlayer();
        int dflLogLevel = PlayerConfig.getDefaultLogLevel();
        if (dflLogLevel >= IjkMediaPlayer.IJK_LOG_VERBOSE && dflLogLevel <= IjkMediaPlayer.IJK_LOG_SILENT) {
            RapidMediaPlayer.setLogLevel(dflLogLevel);
        } else {
            RapidMediaPlayer.setLogLevel(IjkMediaPlayer.IJK_LOG_INFO);
        }
        HashMap<Integer, Map<String, Object>> optionMap = new HashMap<>();
        optionMap.put(IjkMediaPlayer.OPT_CATEGORY_FORMAT, PlayerConfig.getIjkFormatOptions());
        optionMap.put(IjkMediaPlayer.OPT_CATEGORY_CODEC, PlayerConfig.getIjkCodecOptions());
        optionMap.put(IjkMediaPlayer.OPT_CATEGORY_SWS, PlayerConfig.getIjkSwsOptions());
        optionMap.put(IjkMediaPlayer.OPT_CATEGORY_PLAYER, PlayerConfig.getIjkPlayerOptions());
        for (Map.Entry<Integer, Map<String, Object>> optionMapEntry : optionMap.entrySet()) {
            int category = optionMapEntry.getKey();
            Map<String, Object> options = optionMapEntry.getValue();
            for (Map.Entry<String, Object> optionEntry : options.entrySet()) {
                String key = optionEntry.getKey();
                Object value = optionEntry.getValue();
                if (value instanceof String) {
                    ijkMediaPlayer.setOption(category, key, (String) value);
                } else if (value instanceof Long) {
                    ijkMediaPlayer.setOption(category, key, (Long) value);
                } else if (value instanceof Integer) {
                    ijkMediaPlayer.setOption(category, key, (Integer) value);
                }
            }
        }
        ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "live-quick-start", 0);
        ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "mls_read_timeout", 0);
        ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "mls-fragment-interval", 10);
        ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "mls-video-prior-frame", 10);
        if (isAdaptiveBitrate) {
            ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "is-abr-source", 1);
            ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "first_variant_only", 1);
        } else {
            ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "is-abr-source", 0);
            ijkMediaPlayer.setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "first_variant_only", 0);
        }
        return ijkMediaPlayer;
    }
}
