package com.bitkernel.stream.rapid.player;

import com.bitkernel.stream.rapid.RapidAgentSource;
import com.bitkernel.stream.rapid.RapidAgentUri;

public interface RapidPlayerBuilderCallback {
    RapidPlayerBuilder createPlayerBuilder(RapidAgentUri rapidAgentUri);

    PlayerBuilder createPlayerBuilder(RapidAgentSource rapidAgentSource);

    RapidPlayerBuilderCallback DEFAULT = new RapidPlayerBuilderCallback() {
        @Override
        public RapidPlayerBuilder createPlayerBuilder(RapidAgentUri rapidAgentUri) {
            return new RapidPlayerBuilderImpl(rapidAgentUri);
        }

        @Override
        public PlayerBuilder createPlayerBuilder(RapidAgentSource rapidAgentSource) {
            return new RapidAgentOpenBuilder(rapidAgentSource);
        }
    };
}
