package com.bitkernel.stream.rapid.prt;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bitkernel.stream.rapid.RapidAgentExternalDecrypt;
import com.stream.prt.ExternalDecrypt;
import com.stream.prt.ExternalDecryptHelper;

import java.nio.ByteBuffer;

public class PrtExternalDecrypt implements ExternalDecrypt {
    private static final PrtExternalDecrypt INSTANCE = new PrtExternalDecrypt();
    private static RapidAgentExternalDecrypt sExternalDecrypt;

    static {
        ExternalDecryptHelper.setExternalDecrypt(INSTANCE);
    }

    public static void setExternalDecrypt(RapidAgentExternalDecrypt decrypt) {
        sExternalDecrypt = decrypt;
    }

    @Override
    public int sendEncryptedData(int channelId, int trackId, int sessionId, long blockId, @Nullable ByteBuffer inputBuffer, long offset, int flags) {
        if (sExternalDecrypt == null) {
            throw new RuntimeException("There is not an invalid external decrypt");
        }
        return sExternalDecrypt.sendEncryptedData(channelId, trackId, sessionId, blockId, inputBuffer, offset, flags);
    }

    @Override
    public int receiveDecryptedData(int channelId, int trackId, int sessionId, long blockId, @NonNull ByteBuffer outputBuffer, long offset, int flags) {
        if (sExternalDecrypt == null) {
            throw new RuntimeException("There is not an invalid external decrypt");
        }
        return sExternalDecrypt.receiveDecryptedData(channelId, trackId, sessionId, outputBuffer, offset, flags);
    }
}
