package com.bitkernel.stream.rapid.prt;

import static com.bitkernel.stream.rapid.prt.PrtEngine.translate;

import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.bitkernel.stream.rapid.RapidAgentCatchupUri;
import com.bitkernel.stream.rapid.RapidAgentConstant;
import com.bitkernel.stream.rapid.RapidAgentLiveUri;
import com.bitkernel.stream.rapid.RapidAgentUri;
import com.bitkernel.stream.rapid.RapidAgentVodUri;
import com.bitkernel.stream.rapid.utils.AES;
import com.bitkernel.stream.rapid.utils.LogUtil;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

class TokenGenerator {
    private String TOKEN_SECRET_KEY;

    void setTokenSecretKey(String tokenSecretKey) {
        TOKEN_SECRET_KEY = tokenSecretKey;
    }

    String generatePlayToken(String channelId, int solutionType, int solutionBrand, RapidAgentUri rapidAgentUri, String token) throws IOException {
        if (rapidAgentUri instanceof RapidAgentLiveUri) {
            return generateLiveToken(channelId, solutionType, solutionBrand, (RapidAgentLiveUri) rapidAgentUri, token);
        } else if (rapidAgentUri instanceof RapidAgentCatchupUri) {
            return generateCatchupToken(channelId, solutionType, solutionBrand, (RapidAgentCatchupUri) rapidAgentUri, token);
        } else if (rapidAgentUri instanceof RapidAgentVodUri) {
            return generateVodToken(channelId, solutionType, solutionBrand, (RapidAgentVodUri) rapidAgentUri, token);
        } else {
            throw new IOException("Generate play token error, invalid uri : " + rapidAgentUri);
        }
    }

    String generateLiveToken(String channelId, int solutionType, int solutionBrand, @NonNull RapidAgentLiveUri rapidAgentUri, String token) {
        Map<String, Object> params = new LinkedHashMap<>();

        int _nRandNumLess30 = lrand48() % 15;
        byte[] randBytes1 = generateRandomData(_nRandNumLess30 + 6);
        String strRand1 = new String(randBytes1);

        int _nRandNumLess57 = lrand48() % 20;
        byte[] randBytes2 = generateRandomData(_nRandNumLess57 + 6);
        String strRand2 = new String(randBytes2);

        params.put("RELEASEID", RapidAgentConstant.getBrand());
        params.put("RANDSTRING1", strRand1);
        params.put("RANDSTRING2", strRand2);
        params.put("APKSN", RapidAgentConstant.getDeviceId());
        params.put("APPVER", RapidAgentConstant.getSdkVersion());
        params.put("UID", RapidAgentConstant.getAccountId());
        params.put("VNO_ID", RapidAgentConstant.getVnoId());
        if (!TextUtils.isEmpty(rapidAgentUri.getRouteId())) {
            params.put("ROUTE_ID", rapidAgentUri.getRouteId());
        }
        params.put("JWT_TOKEN", token);
        if (rapidAgentUri.getFormat() >= 0) {
            params.put("FORMAT", String.valueOf(rapidAgentUri.getFormat()));
        } else if (rapidAgentUri.isAdaptiveBitrate()) {
            params.put("FORMAT", "1");
        }
        params.put("STREAM_ID", channelId);
        return generateToken(params);
    }

    String generateCatchupToken(String channelId, int solutionType, int solutionBrand, @NonNull RapidAgentCatchupUri rapidAgentUri, String token) throws IOException {
        Map<String, Object> params = new LinkedHashMap<>();

        int _nRandNumLess30 = lrand48() % 15;
        byte[] randBytes1 = generateRandomData(_nRandNumLess30 + 6);
        String strRand1 = new String(randBytes1);

        int _nRandNumLess57 = lrand48() % 20;
        byte[] randBytes2 = generateRandomData(_nRandNumLess57 + 6);
        String strRand2 = new String(randBytes2);

        params.put("VID", RapidAgentConstant.getBrand());
        params.put("USERTYPE", RapidAgentConstant.getUserType());
        params.put("CHN", RapidAgentConstant.getDeviceType());
        params.put("RANDSTRING1", strRand1);
        params.put("RANDSTRING2", strRand2);
        params.put("ASN", RapidAgentConstant.getDeviceId());
        params.put("APPVER", RapidAgentConstant.getSdkVersion());
        params.put("UID", RapidAgentConstant.getAccountId());
        params.put("VNO_ID", RapidAgentConstant.getVnoId());
        if (!TextUtils.isEmpty(rapidAgentUri.getRouteId())) {
            params.put("ROUTE_ID", rapidAgentUri.getRouteId());
        }
        params.put("JWT_TOKEN", token);
        if (rapidAgentUri.getFormat() >= 0) {
            params.put("FORMAT", String.valueOf(rapidAgentUri.getFormat()));
        } else {
            params.put("FORMAT", "1");
        }
        params.put("STREAM_ID", channelId);
        params.put("STARTUTC", rapidAgentUri.getEpgStart());
        params.put("DURATION", rapidAgentUri.getEpgDuration());
        params.put("CODE", "/" + channelId);
        if (rapidAgentUri.isTimeShift()) {
            params.put("PLAYTYPE", "TIMESHIFT");
        } else {
            params.put("PLAYTYPE", "CRT");
        }

        return generateToken(params);
    }

    String generateVodToken(String channelId, int solutionType, int solutionBrand, @NonNull RapidAgentVodUri rapidAgentUri, String token) throws IOException {
        Map<String, Object> params = new LinkedHashMap<>();

        int _nRandNumLess30 = lrand48() % 15;
        byte[] randBytes1 = generateRandomData(_nRandNumLess30 + 6);
        String strRand1 = new String(randBytes1);

        int _nRandNumLess57 = lrand48() % 20;
        byte[] randBytes2 = generateRandomData(_nRandNumLess57 + 6);
        String strRand2 = new String(randBytes2);

        params.put("VID", RapidAgentConstant.getBrand());
        params.put("USERTYPE", RapidAgentConstant.getUserType());
        params.put("CHN", RapidAgentConstant.getDeviceType());
        params.put("RANDSTRING1", strRand1);
        params.put("RANDSTRING2", strRand2);
        params.put("ASN", RapidAgentConstant.getDeviceId());
        params.put("APPVER", RapidAgentConstant.getSdkVersion());
        params.put("UID", RapidAgentConstant.getAccountId());
        params.put("VNO_ID", RapidAgentConstant.getVnoId());
        if (!TextUtils.isEmpty(rapidAgentUri.getRouteId())) {
            params.put("ROUTE_ID", rapidAgentUri.getRouteId());
        }
        params.put("JWT_TOKEN", token);
        if (rapidAgentUri.getFormat() >= 0) {
            params.put("FORMAT", String.valueOf(rapidAgentUri.getFormat()));
        }
        params.put("STREAM_ID", channelId);
        if (rapidAgentUri.getProtocol() == RapidAgentUri.PROTOCOL_MPT) {
            params.put("PLAYTYPE", "MPT");
        } else {
            params.put("PLAYTYPE", "RPD");
        }

        return generateToken(params);
    }

    private String generateToken(@NonNull Map<String, Object> params) {
        if (TextUtils.isEmpty(TOKEN_SECRET_KEY)) {
            throw new IllegalStateException("tokenSecretKey is null");
        }

        StringBuilder sb = new StringBuilder();
        boolean firstItem = true;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (firstItem) {
                firstItem = false;
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            } else {
                sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        LogUtil.sensitive("generateToken by source: " + sb);
        return AES.encrypt(sb.toString(), translate(TOKEN_SECRET_KEY));
    }

    private static int lrand48() {
        int random = new Random().nextInt(Integer.MAX_VALUE);
        return Math.abs(random);
    }

    private static byte[] generateRandomData(int len) {
        int currentIndex = 0;

        byte[] pDataBytes;
        int target;
        for (pDataBytes = new byte[len]; currentIndex < len; pDataBytes[currentIndex++] = (byte) target) {
            int rand1;
            int rand2;
            if (lrand48() % 3 > 0) {
                if ((lrand48() & 1) > 0) {
                    rand1 = lrand48();
                    rand2 = rand1 % 10;
                    target = rand2 + 48;
                } else {
                    rand1 = lrand48();
                    rand2 = rand1 % 26;
                    target = rand2 + 65;
                }
            } else {
                rand1 = lrand48();
                rand2 = rand1 % 26;
                target = rand2 + 97;
            }
        }

        return pDataBytes;
    }
}
