package com.bitkernel.stream.rapid.server;

import android.util.Base64;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class HmacSHA1 {
    static String encrypt(String base, String key) {
        String type = "HmacSHA1";
        SecretKeySpec secret = new SecretKeySpec(key.getBytes(), type);
        Mac mac;
        try {
            mac = Mac.getInstance(type);
            mac.init(secret);
        } catch (NoSuchAlgorithmException | InvalidKeyException e) {
            e.printStackTrace();
            return null;
        }

        byte[] digest = mac.doFinal(base.getBytes());
        return Base64.encodeToString(digest, Base64.NO_WRAP);
    }
}
