package com.bitkernel.stream.rapid.utils;

import android.util.Log;

import com.bitkernel.stream.rapid.BuildConfig;

public class LogUtil {
    public static final boolean PRINT_SENSITIVE = BuildConfig.DEBUG;

    public static int v(String tag, String msg) {
        return Log.v(tag, msg);
    }

    public static int d(String tag, String msg) {
        return Log.d(tag, msg);
    }

    public static int i(String tag, String msg) {
        return Log.i(tag, msg);
    }

    public static int w(String tag, String msg) {
        return Log.w(tag, msg);
    }

    public static int e(String tag, String msg) {
        return Log.e(tag, msg);
    }

    /**
     * Sensitive information logger
     *
     * @return ignore
     */
    public static int sensitive(String msg) {
        if (PRINT_SENSITIVE) {
            return i("RapidSensitive", msg);
        }
        return 0;
    }
}
