package com.bitkernel.stream.rapid.player.utils;

import android.os.Build;

import androidx.annotation.Nullable;

public final class CommonUtil {
    public static int parseInt(Object obj, int defaultValue) {
        return (int) parseLong(obj, defaultValue);
    }

    public static long parseLong(Object obj, int defaultValue) {
        try {
            if (obj instanceof Long) {
                return (long) obj;
            } else if (obj instanceof Integer) {
                return (int) obj;
            } else if (obj instanceof Short) {
                return (short) obj;
            } else if (obj instanceof Byte) {
                return (byte) obj;
            } else if (obj instanceof String) {
                return Long.parseLong((String) obj);
            }
        } catch (Exception e) {
            return defaultValue;
        }
        return defaultValue;
    }

    public static boolean isVirtualMachine() {
        return Build.MANUFACTURER.contains("Genymotion") || Build.MODEL.contains("Emulator") || Build.PRODUCT.contains("sdk") || isX86Device();
    }

    public static boolean isX86Device() {
        String deviceAbi = getDeviceAbi();
        return deviceAbi != null && (deviceAbi.contains("x86") || deviceAbi.contains("X86"));
    }

    @Nullable
    public static String getDeviceAbi() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            if (Build.SUPPORTED_ABIS == null || Build.SUPPORTED_ABIS.length == 0) {
                return null;
            }
            String abi = Build.SUPPORTED_ABIS[0];
            if (abi == null) {
                return null;
            }
            if (abi.startsWith("arm64-v8a")) {
                return "arm64-v8a";
            } else if (abi.startsWith("armeabi-v7a")) {
                return "armeabi-v7a";
            } else if (abi.startsWith("x86_64")) {
                return "x86_64";
            } else if (abi.startsWith("x86")) {
                return "x86";
            } else {
                return abi;
            }
        } else {
            String abi = Build.CPU_ABI;
            if ("arm64-v8a".equals(abi)) {
                return "arm64-v8a";
            } else if ("armeabi-v7a".equals(abi)) {
                return "armeabi-v7a";
            } else if ("x86".equals(abi)) {
                return "x86";
            } else {
                return abi;
            }
        }
    }
}
