package com.bitkernel.stream.rapid.player.egl;

import android.view.Surface;

import androidx.annotation.NonNull;

public interface Renderer {
    void surfaceCreated(Surface surface);

    void surfaceChanged(int width, int height);

    void surfaceDestroyed();

    void setStateChangedListener(OnStateChangedListener listener);

    void setOutputSurface(Surface surface);

    void requestRender(MapsTexture pipeline);

    Surface createInputSurface();

    void releaseInputSurface(Surface surface);

    void disableInputSurface(Surface surface);
}
