package com.bitkernel.stream.rapid.player.utils;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import androidx.annotation.Nullable;

import java.io.IOException;

public class DatabaseHelper extends SQLiteOpenHelper {
    public static final String DB_NAME = "rapid_agent_sdk.db";
    public static final String PLAY_RECORD_TABLE_NAME = "play_record";
    public static final int DB_VERSION = 1;

    public static final String ID = "id";
    public static final String PLAYER_TYPE = "play_type";
    public static final String MIME = "mime";
    public static final String CODEC = "codec";
    public static final String PROFILE = "profile";
    public static final String LEVEL = "level";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SUCCESS_COUNT = "success_count";
    public static final String FAIL_COUNT = "fail_count";

    private static final String SQL_CREATE_PLAY_RECORD_TABLE = "create table " + PLAY_RECORD_TABLE_NAME + "(" +
            ID + " integer primary key autoincrement," +
            PLAYER_TYPE + " integer," +
            MIME + " text," +
            CODEC + " text," +
            PROFILE + " integer," +
            LEVEL + " integer," +
            WIDTH + " integer," +
            HEIGHT + " integer," +
            SUCCESS_COUNT + " integer," +
            FAIL_COUNT + " integer" +
            ")";

    private static DatabaseHelper sInstance;

    private DatabaseHelper(Context context) {
        super(context, DB_NAME, null, DB_VERSION);
    }

    public static void init(@Nullable Context context) {
        if (context == null) {
            Log.w("DatabaseHelper", "Invalid Context Warning : init");
            return;
        }
        if (sInstance == null) {
            synchronized (DatabaseHelper.class) {
                if (sInstance == null) {
                    sInstance = new DatabaseHelper(context);
                }
            }
        }
    }

    public static DatabaseHelper getInstance() throws InvalidContextException {
        if (sInstance == null) {
            throw new InvalidContextException("Invalid Context Warning : DatabaseHelper is not init");
        }
        return sInstance;
    }

    @Override
    public void onCreate(SQLiteDatabase database) {
        database.execSQL(SQL_CREATE_PLAY_RECORD_TABLE);
    }

    @Override
    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
    }

    public static class InvalidContextException extends IOException {
        public InvalidContextException(String message) {
            super(message);
        }
    }
}