package com.bitkernel.stream.rapid.player;

import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public interface IRapidMediaPlayer extends IMediaPlayer {
    int PLAYER_TYPE_UNKNOWN = 0;
    int PLAYER_TYPE_IJK = 1;
    int PLAYER_TYPE_EXO = 2;
    int PLAYER_TYPE_AMP = 3;

    /**
     * @hidden
     */
    int FFP_BUFFERING_REASON_START_REBUILD = 15;
    /**
     * @hidden
     */
    int FFP_BUFFERING_REASON_END_REBUILD = 16;

    int RAPID_ERROR_CATEGORY = -12001;
    int RAPID_ERROR_PREPARE_TIMEOUT = 981;
    int RAPID_ERROR_RESTART_TIMEOUT = 982;
    int RAPID_ERROR_TIME_SHIFT_SEEK_TIMEOUT = 983;

    default void setTrack(int trackType, int trackId) {
        throw new RuntimeException("does not implements method setTrack");
    }

    default int getCurrentTrack(int trackType) {
        throw new RuntimeException("does not implements method getCurrentTrack");
    }

    default int getSelectedTrack(int trackType) {
        throw new RuntimeException("does not implements method getSelectedTrack");
    }

    default void selectTrack(int track) {
        throw new RuntimeException("does not implements method selectTrack");
    }

    default void deselectTrack(int track) {
        throw new RuntimeException("does not implements method deselectTrack");
    }

    default void setPreferVideoTrack(int track) {
        throw new RuntimeException("does not implements method setPreferVideoTrack");
    }

    default void setOnNativeInvokeListener(IjkMediaPlayer.OnNativeInvokeListener listener) {

    }

    int getPlayerType();

    IMediaPlayer getInternalPlayer();
}
