package com.bitkernel.stream.rapid.player.egl;

import android.graphics.SurfaceTexture;
import android.opengl.GLES11Ext;
import android.opengl.GLES20;
import android.util.Log;
import android.view.Surface;

public class MapsTexture implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "MapsTexture";

    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int textureId;
    private int textureIndex;
    private int programIndex;

    private OnFrameAvailableListener frameAvailableListener;

    public void init(int glTextureIndex) {
        int[] textures = new int[1];
        GLES20.glGenTextures(1, textures, 0);
        int[] textureIndex = new int[]{glTextureIndex};

        this.textureId = textures[0];
        this.textureIndex = textureIndex[0];
        this.programIndex = 0;
        GLES20.glActiveTexture(this.textureIndex);
        GLES20.glBindTexture(GLES11Ext.GL_TEXTURE_EXTERNAL_OES, textureId);

        GLES20.glTexParameteri(
                GLES11Ext.GL_TEXTURE_EXTERNAL_OES, GLES20.GL_TEXTURE_MIN_FILTER, GLES20.GL_LINEAR);
        GLES20.glTexParameteri(
                GLES11Ext.GL_TEXTURE_EXTERNAL_OES, GLES20.GL_TEXTURE_MAG_FILTER, GLES20.GL_LINEAR);
        GLES20.glTexParameteri(
                GLES11Ext.GL_TEXTURE_EXTERNAL_OES, GLES20.GL_TEXTURE_WRAP_S, GLES20.GL_CLAMP_TO_EDGE);
        GLES20.glTexParameteri(
                GLES11Ext.GL_TEXTURE_EXTERNAL_OES, GLES20.GL_TEXTURE_WRAP_T, GLES20.GL_CLAMP_TO_EDGE);

        surfaceTexture = new SurfaceTexture(textureId);
        surfaceTexture.setOnFrameAvailableListener(this);
        surface = new Surface(surfaceTexture);
        Log.d(TAG, "createSurface textureId=" + this.textureId + ", textureIndex=" + this.textureIndex);
    }

    public void release() {
        if (surfaceTexture != null) {
            surfaceTexture.release();
            surfaceTexture = null;
        }
        if (surface != null) {
            surface.release();
            surface = null;
        }
        GLES20.glDeleteTextures(1, new int[]{this.textureId}, 0);
        Log.d(TAG, "releaseSurface textureId = " + textureId);
    }

    public Surface getSurface() {
        return surface;
    }

    public void draw(int samplerOESLocation, int texTransformLocation) {
        surfaceTexture.updateTexImage();
        float[] transformMatrix = new float[16];
        surfaceTexture.getTransformMatrix(transformMatrix);
        GLES20.glActiveTexture(textureIndex);
        GLES20.glBindTexture(GLES11Ext.GL_TEXTURE_EXTERNAL_OES, textureId);
        GLES20.glUniform1i(samplerOESLocation, programIndex);
        GLES20.glUniformMatrix4fv(texTransformLocation, 1, false, transformMatrix, 0);
    }

    @Override
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (frameAvailableListener != null) {
            frameAvailableListener.onFrameAvailable(this);
        } else {
            surfaceTexture.updateTexImage();
        }
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener listener) {
        frameAvailableListener = listener;
    }

    public interface OnFrameAvailableListener {
        void onFrameAvailable(MapsTexture pipeline);
    }
}
