/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CheckConfigurationVersionAndExecuteCommand<T>
implements RemoteCommand<T>,
ComparableByContent<CheckConfigurationVersionAndExecuteCommand<?>> {
    private final RemoteCommand<T> targetCommand;
    private final long desiredConfigurationVersion;
    public static final SerializationHandle<CheckConfigurationVersionAndExecuteCommand<?>> SERIALIZATION_HANDLE = new SerializationHandle<CheckConfigurationVersionAndExecuteCommand<?>>(){

        @Override
        public <I> CheckConfigurationVersionAndExecuteCommand<?> deserialize(DeserializationAdapter<I> adapter, I input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_8_1_0, Versions.v_8_1_0);
            RemoteCommand<?> targetCommand = RemoteCommand.deserialize(adapter, input);
            long desiredConfigurationVersion = adapter.readLong(input);
            return new CheckConfigurationVersionAndExecuteCommand(targetCommand, desiredConfigurationVersion);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, CheckConfigurationVersionAndExecuteCommand<?> command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_8_1_0.getNumber());
            RemoteCommand.serialize(adapter, output, ((CheckConfigurationVersionAndExecuteCommand)command).targetCommand, backwardCompatibilityVersion, scope);
            adapter.writeLong(output, ((CheckConfigurationVersionAndExecuteCommand)command).desiredConfigurationVersion);
        }

        @Override
        public int getTypeId() {
            return 42;
        }

        @Override
        public Class<CheckConfigurationVersionAndExecuteCommand<?>> getSerializedType() {
            return CheckConfigurationVersionAndExecuteCommand.class;
        }

        @Override
        public CheckConfigurationVersionAndExecuteCommand<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_8_1_0, Versions.v_8_1_0);
            RemoteCommand<?> targetCommand = RemoteCommand.fromJsonCompatibleSnapshot((Map)snapshot.get("targetCommand"));
            long desiredConfigurationVersion = this.readLongValue(snapshot, "desiredConfigurationVersion");
            return new CheckConfigurationVersionAndExecuteCommand(targetCommand, desiredConfigurationVersion);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(CheckConfigurationVersionAndExecuteCommand<?> command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_8_1_0.getNumber());
            result.put("targetCommand", RemoteCommand.toJsonCompatibleSnapshot(((CheckConfigurationVersionAndExecuteCommand)command).targetCommand, backwardCompatibilityVersion, scope));
            result.put("desiredConfigurationVersion", ((CheckConfigurationVersionAndExecuteCommand)command).desiredConfigurationVersion);
            return result;
        }

        @Override
        public String getTypeName() {
            return "CheckConfigurationVersionAndExecuteCommand";
        }
    };

    public CheckConfigurationVersionAndExecuteCommand(RemoteCommand<T> targetCommand, long desiredConfigurationVersion) {
        this.targetCommand = targetCommand;
        this.desiredConfigurationVersion = desiredConfigurationVersion;
    }

    @Override
    public boolean canBeMerged(RemoteCommand<?> another) {
        if (!(another instanceof CheckConfigurationVersionAndExecuteCommand)) {
            return false;
        }
        CheckConfigurationVersionAndExecuteCommand anotherCmd = (CheckConfigurationVersionAndExecuteCommand)another;
        return this.desiredConfigurationVersion == anotherCmd.desiredConfigurationVersion && this.targetCommand.canBeMerged(anotherCmd.targetCommand);
    }

    @Override
    public RemoteCommand<?> toMergedCommand() {
        return new CheckConfigurationVersionAndExecuteCommand(this.targetCommand.toMergedCommand(), this.desiredConfigurationVersion);
    }

    @Override
    public void mergeInto(RemoteCommand<?> mergedCommand) {
        this.targetCommand.mergeInto(((CheckConfigurationVersionAndExecuteCommand)mergedCommand).targetCommand);
    }

    @Override
    public boolean isMerged() {
        return this.targetCommand.isMerged();
    }

    @Override
    public int getMergedCommandsCount() {
        return this.targetCommand.getMergedCommandsCount();
    }

    @Override
    public CommandResult<?> unwrapOneResult(T result, int indice) {
        return this.targetCommand.unwrapOneResult(result, indice);
    }

    public RemoteCommand<T> getTargetCommand() {
        return this.targetCommand;
    }

    public long getDesiredConfigurationVersion() {
        return this.desiredConfigurationVersion;
    }

    @Override
    public CommandResult<T> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        Long actualConfigurationVersion = state.getConfigurationVersion();
        if (actualConfigurationVersion == null || actualConfigurationVersion < this.desiredConfigurationVersion) {
            return CommandResult.configurationNeedToBeReplaced();
        }
        return this.targetCommand.execute(mutableEntry, currentTimeNanos);
    }

    @Override
    public SerializationHandle<RemoteCommand<?>> getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(CheckConfigurationVersionAndExecuteCommand<?> other) {
        return ComparableByContent.equals(this.targetCommand, other.targetCommand);
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return this.targetCommand.isImmediateSyncRequired(unsynchronizedTokens, nanosSinceLastSync);
    }

    @Override
    public long estimateTokensToConsume() {
        return this.targetCommand.estimateTokensToConsume();
    }

    @Override
    public long getConsumedTokens(T result) {
        return this.targetCommand.getConsumedTokens(result);
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.max(Versions.v_8_1_0, this.targetCommand.getRequiredVersion());
    }
}

