/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiCommand
implements RemoteCommand<MultiResult>,
ComparableByContent<MultiCommand> {
    public static final int MERGING_THRESHOLD = Integer.getInteger("bucket4j.batching.merging-threshold", 5);
    private List<RemoteCommand<?>> commands;
    private int mergedCommands;
    public static SerializationHandle<MultiCommand> SERIALIZATION_HANDLE = new SerializationHandle<MultiCommand>(){

        @Override
        public <S> MultiCommand deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int size = adapter.readInt(input);
            ArrayList results = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                RemoteCommand<?> result = RemoteCommand.deserialize(adapter, input);
                results.add(result);
            }
            return new MultiCommand(results);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, MultiCommand multiCommand, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, multiCommand.commands.size());
            for (RemoteCommand command : multiCommand.commands) {
                RemoteCommand.serialize(adapter, output, command, backwardCompatibilityVersion, scope);
            }
        }

        @Override
        public int getTypeId() {
            return 22;
        }

        @Override
        public Class<MultiCommand> getSerializedType() {
            return MultiCommand.class;
        }

        @Override
        public MultiCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            List commandSnapshots = (List)snapshot.get("commands");
            ArrayList commands = new ArrayList(commandSnapshots.size());
            for (Map commandSnapshot : commandSnapshots) {
                RemoteCommand<?> targetCommand = RemoteCommand.fromJsonCompatibleSnapshot(commandSnapshot);
                commands.add(targetCommand);
            }
            return new MultiCommand(commands);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(MultiCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            ArrayList<Map<String, Object>> commandSnapshots = new ArrayList<Map<String, Object>>(command.commands.size());
            for (RemoteCommand remoteCommand : command.commands) {
                commandSnapshots.add(RemoteCommand.toJsonCompatibleSnapshot(remoteCommand, backwardCompatibilityVersion, scope));
            }
            result.put("commands", commandSnapshots);
            return result;
        }

        @Override
        public String getTypeName() {
            return "MultiCommand";
        }
    };

    public MultiCommand(List<RemoteCommand<?>> commands) {
        this.commands = commands;
    }

    public static MultiCommand merge(List<RemoteCommand<?>> commands) {
        if (commands.size() < MERGING_THRESHOLD) {
            return new MultiCommand(commands);
        }
        int mergedCommandsCount = 0;
        ArrayList mergedCommands = null;
        int size = commands.size();
        for (int i = 0; i < size; ++i) {
            boolean canBeMerged;
            RemoteCommand<?> command = commands.get(i);
            RemoteCommand<?> nextCommand = i + 1 < size ? commands.get(i + 1) : null;
            boolean bl = canBeMerged = nextCommand != null && command.canBeMerged(nextCommand);
            if (!canBeMerged) {
                if (mergedCommands == null) continue;
                mergedCommands.add(command);
                continue;
            }
            if (mergedCommands == null) {
                mergedCommands = new ArrayList(commands.size());
                if (i > 0) {
                    mergedCommands.addAll(commands.subList(0, i));
                }
            }
            RemoteCommand<?> mergedCommand = command.toMergedCommand();
            while (canBeMerged) {
                nextCommand.mergeInto(mergedCommand);
                ++mergedCommandsCount;
                nextCommand = ++i + 1 < size ? commands.get(i + 1) : null;
                canBeMerged = nextCommand != null && command.canBeMerged(nextCommand);
            }
            mergedCommands.add(mergedCommand);
        }
        if (mergedCommands == null) {
            return new MultiCommand(commands);
        }
        MultiCommand multiCommand = new MultiCommand(mergedCommands);
        multiCommand.mergedCommands = mergedCommandsCount;
        return multiCommand;
    }

    public List<CommandResult<?>> unwrap(CommandResult<MultiResult> multiResult) {
        List<CommandResult<?>> results = multiResult.getData().getResults();
        if (!this.isMerged()) {
            return results;
        }
        ArrayList unwrappedResults = new ArrayList(results.size() + this.mergedCommands);
        for (int i = 0; i < this.commands.size(); ++i) {
            RemoteCommand<?> command = this.commands.get(i);
            CommandResult<?> result = results.get(i);
            if (!command.isMerged()) {
                unwrappedResults.add(result);
                continue;
            }
            int mergedCommands = command.getMergedCommandsCount();
            for (int j = 0; j < mergedCommands; ++j) {
                if (result.isError()) {
                    unwrappedResults.add(result);
                    continue;
                }
                CommandResult<?> unwrapped = command.unwrapOneResult(result.getData(), j);
                unwrappedResults.add(unwrapped);
            }
        }
        return unwrappedResults;
    }

    @Override
    public boolean isMerged() {
        return this.mergedCommands > 0;
    }

    @Override
    public CommandResult<MultiResult> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        ArrayList singleResults = new ArrayList(this.commands.size());
        for (RemoteCommand<?> singleCommand : this.commands) {
            singleResults.add(singleCommand.execute(mutableEntry, currentTimeNanos));
        }
        return CommandResult.success(new MultiResult(singleResults), MultiResult.SERIALIZATION_HANDLE);
    }

    @Override
    public boolean isInitializationCommand() {
        for (RemoteCommand<?> command : this.commands) {
            if (!command.isInitializationCommand()) continue;
            return true;
        }
        return false;
    }

    public List<RemoteCommand<?>> getCommands() {
        return this.commands;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public int getMergedCommandsCount() {
        return this.mergedCommands;
    }

    @Override
    public boolean equalsByContent(MultiCommand other) {
        if (this.commands.size() != other.commands.size()) {
            return false;
        }
        for (int i = 0; i < this.commands.size(); ++i) {
            RemoteCommand<?> command2;
            RemoteCommand<?> command1 = this.commands.get(i);
            if (ComparableByContent.equals(command1, command2 = other.commands.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        for (RemoteCommand<?> command : this.commands) {
            if (!command.isImmediateSyncRequired(unsynchronizedTokens, nanosSinceLastSync)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long estimateTokensToConsume() {
        long sum = 0L;
        for (RemoteCommand<?> command : this.commands) {
            if ((sum += command.estimateTokensToConsume()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return sum;
    }

    @Override
    public long getConsumedTokens(MultiResult multiResult) {
        long sum = 0L;
        int count = this.commands.size();
        for (int i = 0; i < count; ++i) {
            RemoteCommand<?> command = this.commands.get(i);
            CommandResult<?> result = multiResult.getResults().get(i);
            if ((sum += result.isError() ? 0L : command.getConsumedTokens(result.getData())) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return sum;
    }

    @Override
    public Version getRequiredVersion() {
        Version max = Versions.v_7_0_0;
        for (RemoteCommand<?> command : this.commands) {
            max = Versions.max(max, command.getRequiredVersion());
        }
        return max;
    }
}

