package com.metric.client.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorThreadPool implements ThreadPool {

    ScheduledExecutorService pool;
    boolean running = false;
    int initialSize = 1;
    String name = "";


    public synchronized void start() {
        if (running)
            return;
        running = true;
        pool = Executors.newScheduledThreadPool(initialSize, new ThreadFactory() {
            private int num = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "metric-agent-" + num++);
                return t;
            }
        });
    }

    public int getInitialSize() {
        return initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public synchronized void stop() {
        if (!running)
            return;
        running = false;
        pool.shutdownNow();
        pool = null;
    }

    public void background(Runnable job) {
        if (!running) {
            return;
        }

        pool.execute(job);
    }

    public void background(Runnable callable, long delay, TimeUnit unit) {
        if (!running) {
            return;
        }
        pool.schedule(callable, delay, unit);
    }
}
