/*
 * Decompiled with CFR 0.152.
 */
package com.metric.client;

import com.metric.client.MetricConfig;
import com.metric.client.utils.ExecutorThreadPool;
import com.metric.common.CryptTools;
import com.metric.common.escape.Escaper;
import com.metric.common.escape.Escapers;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MetricAgent {
    private static final Escaper FIELD_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").build();
    private static final Escaper KEY_ESCAPER = Escapers.builder().addEscape(' ', "\\ ").addEscape(',', "\\,").addEscape('=', "\\=").build();
    private static final int MAX_FRACTION_DIGITS = 340;
    private static ExecutorThreadPool threadPool;
    private static String appId;
    private static String appKey;
    private static String serverUrl;
    private static boolean debug;
    private static BlockingQueue<MetricEvent> eventQueue;
    private static int eventQueueLimit;
    private static int postBatchSize;

    private static boolean isInit() {
        return threadPool != null;
    }

    public static void setDebug(boolean d) {
        debug = d;
    }

    public static void init(String appId, String appKey, String serverUrl) {
        if (MetricAgent.isInit()) {
            return;
        }
        MetricConfig metricConfig = new MetricConfig();
        metricConfig.setAppId(appId);
        metricConfig.setAppKey(appKey);
        metricConfig.setServerUrl(serverUrl);
        MetricAgent.init(metricConfig);
    }

    public static void init(MetricConfig metricConfig) {
        if (MetricAgent.isInit()) {
            return;
        }
        appId = metricConfig.getAppId();
        appKey = metricConfig.getAppKey();
        String appendServerUrl = metricConfig.getServerUrl();
        if (!appendServerUrl.endsWith("/")) {
            appendServerUrl = appendServerUrl + "/";
        }
        serverUrl = appendServerUrl;
        eventQueueLimit = metricConfig.getBufferQueueSize();
        eventQueue = new LinkedBlockingQueue<MetricEvent>(eventQueueLimit);
        postBatchSize = metricConfig.getPostBatchSize();
        threadPool = new ExecutorThreadPool();
        threadPool.setInitialSize(metricConfig.getThreadPoolSize() > 1 ? metricConfig.getThreadPoolSize() : 1);
        threadPool.start();
        threadPool.background(new PostRun());
    }

    public static void postEvent(String eventName, Map<String, String> tagMap, Map<String, Object> fieldMap) {
        block7: {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
                numberFormat.setMaximumFractionDigits(340);
                numberFormat.setGroupingUsed(false);
                numberFormat.setMinimumFractionDigits(1);
                String tags = "";
                for (Map.Entry<String, String> tagEntry : tagMap.entrySet()) {
                    if (tagEntry.getValue() == null || tagEntry.getValue().trim().equals("")) continue;
                    String tagValue = tagEntry.getValue();
                    tags = tags + KEY_ESCAPER.escape(tagEntry.getKey()) + "=" + KEY_ESCAPER.escape(tagValue);
                    tags = tags + ",";
                }
                tags = tags.substring(0, tags.length() - 1);
                String fields = "";
                for (Map.Entry<String, Object> fieldEntry : fieldMap.entrySet()) {
                    fields = fields + KEY_ESCAPER.escape(fieldEntry.getKey()) + "=";
                    Object value = fieldEntry.getValue();
                    if (value == null) {
                        if (!debug) continue;
                        System.out.println("MetricAgent: Ignore empty field value of key " + fieldEntry.getKey());
                        continue;
                    }
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        fields = fields + "\"" + FIELD_ESCAPER.escape(stringValue) + "\"";
                    } else {
                        fields = value instanceof Number ? (value instanceof Double || value instanceof Float || value instanceof BigDecimal ? fields + numberFormat.format(value) : fields + value + "i") : fields + value;
                    }
                    fields = fields + ",";
                }
                fields = fields.substring(0, fields.length() - 1);
                MetricAgent.postEvent(eventName, tags, fields);
            }
            catch (Exception e) {
                if (!debug) break block7;
                System.out.println("MetricAgent: Error postEvent: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void postEvent(String eventName, String tags, String fields) {
        block6: {
            if (!MetricAgent.isInit()) {
                System.out.println("MetricAgent is not initialized");
                return;
            }
            int eventQueueSize = eventQueue.size();
            if (eventQueueSize >= eventQueueLimit) {
                System.out.println(String.format("MetricAgent: Reached buffer limit[%s], dropped new event[%s]", eventQueueSize, eventName));
                return;
            }
            MetricEvent metricEvent = new MetricEvent();
            metricEvent.name = eventName;
            metricEvent.tags = tags;
            metricEvent.fields = fields;
            try {
                boolean offered = eventQueue.offer(metricEvent, 0L, TimeUnit.MILLISECONDS);
                if (!offered) {
                    System.out.println(String.format("MetricAgent: Failed push event to buffer, dropped new event[%s]", eventName));
                }
            }
            catch (Exception e) {
                if (!debug) break block6;
                System.out.println("MetricAgent: Error in push event to buffer: " + e.getMessage());
            }
        }
        if (debug) {
            System.out.println(String.format("MetricAgent: postEvent scheduled: eventName[%s] tags[%s] fields[%s]", eventName, tags, fields));
        }
    }

    private static void postEvents(String eventsBody) throws Exception {
        String postUrl = serverUrl + "api/metric/batchpostevent/v2";
        URL url = URI.create(postUrl).toURL();
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("POST");
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(51000);
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConnection.setRequestProperty("charset", "utf-8");
        urlConnection.setRequestProperty("User-Agent", "MetricAgent 1.0");
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        HashMap<String, String> postDataParams = new HashMap<String, String>();
        postDataParams.put("app_id", appId);
        postDataParams.put("app_key", appKey);
        postDataParams.put("events", eventsBody);
        HashMap<String, String> postMsg = new HashMap<String, String>();
        postMsg.put("v", "1");
        postMsg.put("m", CryptTools.encrypt((String)MetricAgent.getPostDataString(postDataParams)));
        OutputStream os = urlConnection.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        writer.write(MetricAgent.getPostDataString(postMsg));
        writer.flush();
        writer.close();
        os.close();
        int responseCode = urlConnection.getResponseCode();
        if (responseCode == 200) {
            if (debug) {
                System.out.println(String.format("postEvent OK: %s", eventsBody));
            }
        } else if (debug) {
            System.out.println(String.format("postEvent server failed[%s]: %s", responseCode, eventsBody));
        }
    }

    private static String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    static {
        debug = false;
    }

    private static class PostRun
    implements Runnable {
        private PostRun() {
        }

        @Override
        public void run() {
            while (true) {
                ArrayList<MetricEvent> eventList = new ArrayList<MetricEvent>();
                try {
                    MetricEvent srcMetricEvent = (MetricEvent)eventQueue.take();
                    eventList.add(srcMetricEvent);
                    while ((srcMetricEvent = (MetricEvent)eventQueue.poll(1000L, TimeUnit.MILLISECONDS)) != null) {
                        eventList.add(srcMetricEvent);
                        if (eventList.size() < postBatchSize) continue;
                    }
                    if (eventList.isEmpty()) continue;
                    String eventSplitStr = "\n";
                    String fieldSplitStr = "#$#";
                    String eventsBody = "";
                    for (MetricEvent metricEvent : eventList) {
                        eventsBody = eventsBody + metricEvent.name + fieldSplitStr + metricEvent.tags + fieldSplitStr + metricEvent.fields + eventSplitStr;
                    }
                    eventsBody = eventsBody.substring(0, eventsBody.length() - 1);
                    MetricAgent.postEvents(eventsBody);
                    if (!debug) continue;
                    System.out.println("MetricAgent: posted event count: " + eventList.size());
                    continue;
                }
                catch (Throwable e) {
                    if (!debug) continue;
                    System.out.println("MetricAgent: Error in PostRun: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class MetricEvent {
        public String name;
        public String tags;
        public String fields;

        private MetricEvent() {
        }
    }
}

