/*
 * Decompiled with CFR 0.152.
 */
package com.metric.client.utils;

import com.metric.client.utils.ThreadPool;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorThreadPool
implements ThreadPool {
    ScheduledExecutorService pool;
    boolean running = false;
    int initialSize = 1;
    String name = "";

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.pool = Executors.newScheduledThreadPool(this.initialSize, new ThreadFactory(){
            private int num = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "metric-agent-" + this.num++);
                return t;
            }
        });
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.pool.shutdownNow();
        this.pool = null;
    }

    @Override
    public void background(Runnable job) {
        if (!this.running) {
            return;
        }
        this.pool.execute(job);
    }

    @Override
    public void background(Runnable callable, long delay, TimeUnit unit) {
        if (!this.running) {
            return;
        }
        this.pool.schedule(callable, delay, unit);
    }
}

