package com.metric.common.security;


import java.nio.charset.StandardCharsets;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;


/**
 *
 */
public class AESTools {
    /**
     * AES
     */
    public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = null;
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, skey, ivSpec);
            crypted = cipher.doFinal(input);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return crypted;
    }

    public static String encryptToBase64(String input, byte[] key, byte[] iv) {
        byte[] crypted = encrypt(input.getBytes(), key, iv);
        return encodeBase64UrlSafe(crypted);
    }

    public static String encryptToBase64(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = encrypt(input, key, iv);
        return encodeBase64UrlSafe(crypted);
    }

    /**
     * AES
     */
    public static byte[] decrypt(byte[] input, byte[] key, byte[] iv) {
        try {
            byte[] output = null;
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, skey, ivSpec);
            output = cipher.doFinal(input);
            return output;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    public static String decryptToString(String input, byte[] key, byte[] iv) {
        byte[] bytes = decrypt(input.getBytes(), key, iv);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String encryptToBase64(String input, String key, String iv) {
        byte[] keyBytes = decodeBase64UrlSafe(key);
        byte[] ivBytes = decodeBase64UrlSafe(key);
        return encryptToBase64(input.getBytes(), keyBytes, ivBytes);
    }

    public static String decryptToString(String input, String key, String iv) {
        byte[] keyBytes = decodeBase64UrlSafe(key);
        byte[] ivBytes = decodeBase64UrlSafe(key);
        byte[] msgBytes = decodeBase64UrlSafe(input);
        return new String(decrypt(msgBytes, keyBytes, ivBytes));
    }

    public static String encodeBase64UrlSafe(String src) {
        if (src == null || src.length() == 0) {
            return "";
        }

        return Base64JDK8.getUrlEncoder().encodeToString(src.getBytes(StandardCharsets.UTF_8));
    }

    public static String encodeBase64UrlSafe(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }

        return Base64JDK8.getUrlEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBase64UrlSafe(String src) {
        if (src == null || src.length() == 0) {
            return new byte[0];
        }

        return Base64JDK8.getUrlDecoder().decode(src.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64UrlSafeToString(String src) {
        return new String(decodeBase64UrlSafe(src));
    }

}