/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.foundation.internals.provider;

import com.ctrip.framework.foundation.internals.Utils;
import com.ctrip.framework.foundation.internals.io.BOMInputStream;
import com.ctrip.framework.foundation.spi.provider.Provider;
import com.ctrip.framework.foundation.spi.provider.ServerProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerProvider
implements ServerProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServerProvider.class);
    private static final String SERVER_PROPERTIES_LINUX = "/opt/settings/server.properties";
    private static final String SERVER_PROPERTIES_WINDOWS = "C:/opt/settings/server.properties";
    private String m_env;
    private String m_dc;
    private Properties m_serverProperties = new Properties();

    @Override
    public void initialize() {
        try {
            String path = Utils.isOSWindows() ? SERVER_PROPERTIES_WINDOWS : SERVER_PROPERTIES_LINUX;
            File file = new File(path);
            if (file.exists() && file.canRead()) {
                logger.info("Loading {}", (Object)file.getAbsolutePath());
                FileInputStream fis = new FileInputStream(file);
                this.initialize(fis);
                return;
            }
            this.initialize(null);
        }
        catch (Throwable ex) {
            logger.error("Initialize DefaultServerProvider failed.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InputStream in) {
        try {
            if (in != null) {
                try {
                    this.m_serverProperties.load(new InputStreamReader((InputStream)new BOMInputStream(in), StandardCharsets.UTF_8));
                }
                finally {
                    in.close();
                }
            }
            this.initEnvType();
            this.initDataCenter();
        }
        catch (Throwable ex) {
            logger.error("Initialize DefaultServerProvider failed.", ex);
        }
    }

    @Override
    public String getDataCenter() {
        return this.m_dc;
    }

    @Override
    public boolean isDataCenterSet() {
        return this.m_dc != null;
    }

    @Override
    public String getEnvType() {
        return this.m_env;
    }

    @Override
    public boolean isEnvTypeSet() {
        return this.m_env != null;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        if ("env".equalsIgnoreCase(name)) {
            String val = this.getEnvType();
            return val == null ? defaultValue : val;
        }
        if ("dc".equalsIgnoreCase(name)) {
            String val = this.getDataCenter();
            return val == null ? defaultValue : val;
        }
        String val = this.m_serverProperties.getProperty(name, defaultValue);
        return val == null ? defaultValue : val.trim();
    }

    @Override
    public Class<? extends Provider> getType() {
        return ServerProvider.class;
    }

    private void initEnvType() {
        this.m_env = System.getProperty("env");
        if (!Utils.isBlank(this.m_env)) {
            this.m_env = this.m_env.trim();
            logger.info("Environment is set to [{}] by JVM system property 'env'.", (Object)this.m_env);
            return;
        }
        this.m_env = System.getenv("ENV");
        if (!Utils.isBlank(this.m_env)) {
            this.m_env = this.m_env.trim();
            logger.info("Environment is set to [{}] by OS env variable 'ENV'.", (Object)this.m_env);
            return;
        }
        this.m_env = this.m_serverProperties.getProperty("env");
        if (!Utils.isBlank(this.m_env)) {
            this.m_env = this.m_env.trim();
            logger.info("Environment is set to [{}] by property 'env' in server.properties.", (Object)this.m_env);
            return;
        }
        this.m_env = null;
        logger.info("Environment is set to null. Because it is not available in either (1) JVM system property 'env', (2) OS env variable 'ENV' nor (3) property 'env' from the properties InputStream.");
    }

    private void initDataCenter() {
        this.m_dc = System.getProperty("idc");
        if (!Utils.isBlank(this.m_dc)) {
            this.m_dc = this.m_dc.trim();
            logger.info("Data Center is set to [{}] by JVM system property 'idc'.", (Object)this.m_dc);
            return;
        }
        this.m_dc = System.getenv("IDC");
        if (!Utils.isBlank(this.m_dc)) {
            this.m_dc = this.m_dc.trim();
            logger.info("Data Center is set to [{}] by OS env variable 'IDC'.", (Object)this.m_dc);
            return;
        }
        this.m_dc = this.m_serverProperties.getProperty("idc");
        if (!Utils.isBlank(this.m_dc)) {
            this.m_dc = this.m_dc.trim();
            logger.info("Data Center is set to [{}] by property 'idc' in server.properties.", (Object)this.m_dc);
            return;
        }
        this.m_dc = null;
        logger.debug("Data Center is set to null. Because it is not available in either (1) JVM system property 'idc', (2) OS env variable 'IDC' nor (3) property 'idc' from the properties InputStream.");
    }

    public String toString() {
        return "environment [" + this.getEnvType() + "] data center [" + this.getDataCenter() + "] properties: " + this.m_serverProperties + " (DefaultServerProvider)";
    }
}

