package com.cv.media.lib.androidlua;

import android.text.TextUtils;
import android.util.Log;

import com.google.gson.Gson;

import org.apache.commons.io.FileUtils;
import org.keplerproject.luajava.LuaState;
import org.keplerproject.luajava.LuaStateFactory;

import java.io.File;
import java.nio.charset.Charset;

public class LuaUtils {
    private final static String TAG = "LuaUtils";

    public static String executeLua(String luaScript) {
        try {
            LuaState lua = LuaStateFactory.newLuaState();
            lua.openLibs();
            lua.LdoString(luaScript);
            lua.getGlobal("result");
            String result = lua.toString(-1);
            lua.close();
            return result;
        } catch (Exception e) {
            Log.e(TAG, "execute lua script error", e);
            return "";
        }
    }

    public static <T> T fromLua(String luaScript, Class<T> tClass) {
        try {
            if (!TextUtils.isEmpty(luaScript)) {
                String luaResult = executeLua(luaScript);
                if (!TextUtils.isEmpty(luaResult)) {
                    /*Type type = new TypeToken<T>() {
                    }.getType();*/

                    Gson gson = new Gson();
                    T result = gson.fromJson(luaResult, tClass); // todo 验证这里是否可以处理复杂类型
                    return result;
                } else {
                    Log.w(TAG, "lua script result is empty!");
                    return null;
                }
            } else {
                Log.w(TAG, "lua script is empty!");
                return null;
            }
        } catch (Exception e) {
            Log.e(TAG, "from lua script error", e);
            return null;
        }
    }

    public static <T> T fromLua(File file, Class<T> tClass) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }

        try {
            String luaScript = FileUtils.readFileToString(file, Charset.defaultCharset());
            if (!TextUtils.isEmpty(luaScript)) {
                return fromLua(luaScript, tClass);
            } else {
                Log.w(TAG, "lua script from file is empty!");
                return null;
            }
        } catch (Exception e) {
            Log.e(TAG, "from lua file error", e);
            return null;
        }
    }

    public static <T> T fromLuaWithParam(String luaScript, Class<T> tClass, Object param) {
        try {
            if (!TextUtils.isEmpty(luaScript)) {
                LuaState lua = LuaStateFactory.newLuaState();
                lua.openLibs();
                lua.LdoString(luaScript);
                lua.getGlobal("main");
                lua.pushJavaObject(param);
                lua.pcall(1, 1, 0);
                String luaResult = lua.toString(-1);
                lua.close();
                if (!TextUtils.isEmpty(luaResult)) {
                    /*Type type = new TypeToken<T>() {
                    }.getType();*/

                    Gson gson = new Gson();
                    T result = gson.fromJson(luaResult, tClass); // todo 验证这里是否可以处理复杂类型
                    return result;
                } else {
                    Log.w(TAG, "lua script result is empty!");
                    return null;
                }
            } else {
                Log.w(TAG, "lua script is empty!");
                return null;
            }
        } catch (Exception e) {
            Log.e(TAG, "from lua file error", e);
            return null;
        }
    }
}
