package com.cv.media.lib.api;

import android.util.Log;

import com.cv.media.lib.api.pct.PctInitializer;
import com.tor.ext.okhttp.PctInterceptor;
import com.tor.ext.okhttp.metric.PctMetricEventListener;

import java.io.IOException;
import java.util.Map;

import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.Response;

/**
 * Created by zhangyaoa on 2023/6/29.
 */
public class PctInterceptorWrapper extends PctInterceptor {

    public PctInterceptorWrapper() {
        super(CookieJar.NO_COOKIES, 0L, 0L, new PctMetricEventListener.MetricStorage() {
            @Override
            public void saveMetric(Call call, Map<String, Object> metricMap) {
            }

            @Override
            public void reportSLA(Call call, Map<String, Object> slaMap) {
                NW_ApiRequestEvent apiRequestEvent = NetWorksMonitor.getInstance().callToRequest(call);
                synchronized (NetWorksMonitor.getInstance()) {
                    apiRequestEvent.setPct(slaMap);
                    try {
                        int errorCode = (int) slaMap.get("pct_error_code");
                        if (errorCode >= 900 && errorCode <= 1000) {
                            return;
                        }
                    } catch (Exception exception) {
                        Log.w("PctCb", "warning:!!!!!! Pct Callback error", exception);
                        return;
                    }
                    apiRequestEvent.callEnd(call);
                }
            }
        });
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        if (PctInitializer.isForceOpen() || PctInitializer.isInitSuccess()) {
            return super.intercept(chain);
        }
        return chain.proceed(chain.request());
    }
}
