package com.cv.media.lib.api;

import com.cv.media.lib.common_utils.provider.ContextProvider;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import me.ew.rdns.lib.Rdns;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * 支持服务器主机地址 切换
 *
 * @Author Damon
 */
public abstract class BaseHostSwitchInterceptor implements Interceptor {
    private final me.ew.rdns.lib.intercept.BaseHostSwitchInterceptor mInterceptor = new me.ew.rdns.lib.intercept.BaseHostSwitchInterceptor() {
        @Override
        public List<String> onAddHosts() {
            return BaseHostSwitchInterceptor.this.onAddHosts();
        }

        @Override
        public void onPreProcess(Request request) {
            BaseHostSwitchInterceptor.this.onPreProcess(request);
        }

        @Override
        public List<String> addWhiteCodeList() {
            return Collections.singletonList("555");
        }
    };

    public BaseHostSwitchInterceptor() {
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        try {
            return mInterceptor.intercept(chain);
        }catch (ConnectException e) {
            if (mInterceptor.getHost() == null) throw new ConnectException(ContextProvider.getContext().getString(R.string.error_host));
            throw new ConnectException(ContextProvider.getContext().getString(R.string.error_connection));
        }
    }

    final String getHost() {
        return mInterceptor.getHost();
    }

    abstract protected List<String> onAddHosts();

    abstract protected void onPreProcess(Request request);
}
