package com.cv.media.lib.api.pct;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

import com.cv.media.lib.api.BuildConfig;
import com.cv.media.lib.common_utils.callback.ICallBack;
import com.cv.media.lib.common_utils.ntp.TrueTime;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.JsonUtil;
import com.cv.media.lib.common_utils.utils.storage.DirectoryUtils;
import com.cv.media.lib.metric.data.MetricData;
import com.cv.media.lib.metric.manager.MetricManager;
import com.pct.core.PctEngine;
import com.pct.core.PctStrategy;
import com.pct.core.log.Logger;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import me.ew.rdns.lib.Rdns;

/**
 * Created by zhangyaoa on 2023/6/21.
 */
public class PctInitializer {
    private static final String PCT_WORK_PATH;
    private static final String PCT_LIB_PATH;

    private static boolean hasInit = false;


    static {
        PCT_WORK_PATH = DirectoryUtils.getExternalDir("pct") + "work";
        PCT_LIB_PATH = DirectoryUtils.getExternalDir("pct") + "lib";
    }


    public static void init(boolean isDebug,String soUpdatePath, PctLocalConfig localConfig, String remoteConfigJson, HashMap<String, String> remoteHosts, ICallBack<Map<String, Object>> initInfoCb) {
        if (localConfig == null) {
            return;
        }

        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("you cant init in main thread!");
        }

        //        Log.d("pct server config : ", remoteConfigJson + "");
        PctRemoteConfig remoteConfig = null;
        if (!TextUtils.isEmpty(remoteConfigJson)) {
            remoteConfig = JsonUtil.parseJsonToBean(remoteConfigJson, PctRemoteConfig.class);
        }

        //直接禁用，啥都不做了
        if (remoteConfig != null && !remoteConfig.isEnableInit()) {
            Log.i("pct init : ", "disable by remote config");
            return;
        }


//        String configAssets = JsonUtil.getJsonFromAssets(localConfigPath, ContextProvider.getContext());
//
//        if (TextUtils.isEmpty(configAssets)) {
//            return;
//        }

//        Log.d("pct local config : ", configAssets);
//        PctLocalConfig localConfig = JsonUtil.parseJsonToBean(configAssets, PctLocalConfig.class);

        HashMap<String, String> engineParams = new HashMap<>();
        engineParams.put("PCT_REQ_NAV_URL", localConfig.getCustom_app_pct_nav_url());
        engineParams.put("HARDWARE_TYPE", localConfig.getCustom_app_pct_hard_type());
        engineParams.put("LOG_SERVER_ADDRESS", localConfig.getCustom_app_pct_log_config());
        engineParams.put("APP_CHANNEL", localConfig.getCustom_app_pct_release_id());

        //Todo pct2.0 的 engineParams有变化

        if (remoteHosts != null && !remoteHosts.isEmpty()) {
            //用下发的域名配置替换BuildConfig里面的域名
            localConfig.setCustom_app_pct_sid_servers(remoteHosts);
        }

//        Log.d("pct local nav url", localConfig.getCustom_app_pct_nav_url());

        updateSidFromRdns(localConfig);

//        Log.d("pct local domins", localConfig.getCustom_app_pct_navigators()[0] + "\n" + localConfig.getCustom_app_pct_navigators()[1]);

        PctStrategy strategy = new PctStrategy()
                .workPath(PCT_WORK_PATH)
                .appKey(localConfig.getCustom_app_pct_key())
                .releaseId(localConfig.getCustom_app_pct_release_id())
                .pctUrlMap(localConfig.getCustom_app_pct_sid_servers())
                .navigatorDomains(localConfig.getCustom_app_pct_navigators())
                .blacklist(localConfig.getCustom_app_pct_black_list())
                .engineParams(engineParams)
                .libPath(soUpdatePath == null ? "" : soUpdatePath)
                .setBikCorePath("")
                .connectWaitTime(TimeUnit.SECONDS.toMillis(30))
                .failedAffectTime(TimeUnit.SECONDS.toMillis(60))
                .callTimeout(TimeUnit.SECONDS.toMillis(60))
                .readTimeout(TimeUnit.SECONDS.toMillis(30))
                .logLevel(isDebug ? Logger.DEBUG : Logger.INFO)
                .statisticPostInterval(TimeUnit.MINUTES.toMillis(5))
                .saveTaskMetric(true)
                .callback(new PctEngine.ICallback() {
                    @Override
                    public String[] resolveDNS(String s) {
                        try {
                            List<InetAddress> addressList = Rdns.getInstance().lookup(s);
                            String[] ret = new String[addressList.size()];
                            for (int i = 0; i < addressList.size(); i++) {
                                String addr = addressList.get(i).getHostAddress();
                                ret[i] = addr;
                                Log.d("pct resolve dns : ", ret[i]);
                            }
                            return ret;
                        } catch (UnknownHostException e) {
                            return null;
                        }
                    }

                    @Override
                    public void onMetric(String action, Map<String, Object> map) {
                        MetricManager.getInstance().put(MetricManager.MetricKey.PCT, action, new MetricData.Builder().put(map).build());
                    }

                    @Override
                    public int onEvent(int i, long l, long l1, String s) {
                        try {
                            Log.d("vod_pct_navigator_event", "" + i);
                            Map<String, Object> metricMap = new HashMap<>();
                            metricMap.put("pct_event_id", String.valueOf(i));
                            metricMap.put("pct_event_info", TextUtils.isEmpty(s) ? "null" : s);
                            MetricManager.getInstance().put(MetricManager.MetricKey.APP, localConfig.getCustom_app_pct_metric_action(), new MetricData.Builder().put(metricMap).build());
                        } catch (Exception ex) {

                        }
                        return 0;
                    }

                    @Override
                    public long onGetTrueTime() {
                        return TrueTime.getInstance().currentTimeMillis();
                    }

                    @Override
                    public void onPctConnected(Map<String, Object> map) {
                        if (initInfoCb != null) {
                            initInfoCb.call(map);
                        }
                    }
                });

        if (remoteConfig != null) {
            if (remoteConfig.getEngineParams() != null && remoteConfig.getEngineParams().size() > 0) {
                strategy.engineParams(remoteConfig.getEngineParams());
            }

            if (remoteConfig.getConnectWaitTime() > 0) {
                strategy.connectWaitTime(remoteConfig.getConnectWaitTime());
            }
            if (remoteConfig.getFailedAffectTime() > 0) {
                strategy.failedAffectTime(remoteConfig.getFailedAffectTime());
            }
            if (remoteConfig.getCallTimeout() > 0) {
                strategy.callTimeout(remoteConfig.getCallTimeout());
            }
            if (remoteConfig.getReadTimeout() > 0) {
                strategy.readTimeout(remoteConfig.getReadTimeout());
            }
            if (remoteConfig.getStatisticPostInterval() > 0) {
                strategy.statisticPostInterval(remoteConfig.getStatisticPostInterval());
            }
            if (remoteConfig.getBlacklist() != null && remoteConfig.getBlacklist().size() > 0) {
                strategy.blacklist(remoteConfig.getBlacklist());
            }
            if (remoteConfig.getWhitelist() != null && remoteConfig.getWhitelist().size() > 0) {
                strategy.whitelist(remoteConfig.getWhitelist());
            }

            strategy.startEngine(remoteConfig.isPctEnable())
                    .pctEnable(remoteConfig.isPctEnable())
                    .saveTaskMetric(remoteConfig.isSaveTaskMetric());
        }

        try {
            PctEngine.init(strategy);
            hasInit = true;
        } catch (Exception e) {
            hasInit = false;
        }
    }

    private static void updateSidFromRdns(PctLocalConfig localConfig) {
        try {
            HashMap<String, String> rdnsSidServers = new HashMap<>();
            String[] originalServers = (String[]) localConfig.getCustom_app_pct_sid_servers().keySet().toArray();
            for (int i = 0; i < originalServers.length; i++) {
                String sRpl = Rdns.getInstance().lookupRpl(originalServers[i]);
                if (!TextUtils.isEmpty(sRpl)) {
                    String sPct = Rdns.getInstance().lookupPCT(sRpl);
                    if (!TextUtils.isEmpty(sPct)) {
                        rdnsSidServers.put(sRpl, sPct);
                    }
                }
            }

            if (rdnsSidServers.size() > 0) {
                //包含原来的域名也没关系
                localConfig.getCustom_app_pct_sid_servers().putAll(rdnsSidServers);
            }
        } catch (Exception e) {

        }

    }

    public static boolean isInitSuccess() {
        return hasInit;
    }
}
