package com.cv.media.lib.api;

import java.io.IOException;
import java.util.HashSet;

import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class InterceptorTail implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        NetWorksMonitor.getInstance().requestOut(request, chain.call());
        Response response = chain.proceed(request);
        NetWorksMonitor.getInstance().responseIn(response, chain.call());
        return response;
    }
}
