package com.cv.media.lib.api;

import androidx.annotation.Nullable;

import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;

import okhttp3.Call;
import okhttp3.Handshake;
import okhttp3.Protocol;

/**
* 描述一次连接
* 职责:
* @author Damon
*/
public class NW_ConnectionNode extends NW_Base implements KeepClassMember {
    private long connectStartTs;
    private long connectEndTs;
    private long secureConnectStartTs;
    private long secureConnectEndTs;
    private String errorString;
    private String protocol;

    public NW_ConnectionNode() {
        reset();
    }

    @Override
    void reset() {
        connectStartTs = INVALID;
        connectEndTs = INVALID;
        secureConnectStartTs = INVALID;
        secureConnectEndTs = INVALID;
        errorString = null;
        protocol = null;
    }

    @Override
    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        connectStartTs = cts();
    }

    @Override
    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        connectEndTs = cts();
        if (protocol != null) this.protocol = protocol.toString();
    }

    @Override
    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        connectEndTs = cts();
        errorString = ioe.toString();
    }

    @Override
    public void secureConnectStart(Call call) {
        secureConnectStartTs = cts();
    }

    @Override
    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        secureConnectEndTs = cts();
    }
}
