package com.cv.media.lib.api;

import com.cv.media.lib.common_utils.utils.GsonUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.http.Query;

/**
 * Created by zhangyaoa on 2023/9/11.
 */
public class SdkAdaptConvertFactory extends Converter.Factory {
    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return super.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
    }

    @Override
    public Converter<?, String> stringConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (annotations[0] instanceof Query) {

            return value -> {
                if(value instanceof SdkAdaptSingle || value instanceof SdkAdaptList){
//                    SdkAdaptObj sdkAdaptObj = new SdkAdaptObj(GsonUtil.getGson().toJson(value), getRawType(type).getName());
                    SdkAdaptObj sdkAdaptObj = new SdkAdaptObj(GsonUtil.getGson().toJson(value), getRawType(((ParameterizedType) type).getActualTypeArguments()[0]).getName());
                    return "SdkAdapt:" + GsonUtil.getGson().toJson(sdkAdaptObj);
                }

                return String.valueOf(value);
            };
        }

        return super.stringConverter(type, annotations, retrofit);
    }
}
