package com.cv.media.lib.api.okhttp;

import com.cv.media.lib.api.HttpMethod;
import com.cv.media.lib.common_utils.utils.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.Response;

/**
 * 职责: 请求前 添加通用参数 两个维度 一个头部 一个数据参数
 *
 * @Author Damon
 */
public abstract class BaseParamsInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder newRequest = request.newBuilder();
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        Map<String, String> newParams;
        Map<String, String> newHeaderParams;
        synchronized (this) {
             newParams = onAddParams(request);
             newHeaderParams = onAddHeaderParams(request);
            if (newParams != null) newParams = new HashMap<>(newParams);
            else newParams = new HashMap<>();

            if (newHeaderParams != null) newHeaderParams = new HashMap<>(newHeaderParams);
            else newHeaderParams = new HashMap<>();
        }

        if (request.method().equals(HttpMethod.GET) || (request.method().equals(HttpMethod.POST) && request.body() instanceof MultipartBody)) {
            urlBuilder.encodedQuery(null);  //clear query params First
            for (int i = 0; i < request.url().querySize(); i++) {
                String name = request.url().queryParameterName(i);
                String value = request.url().queryParameterValue(i);
                if (!value.isEmpty()) {
                    if (newParams.containsKey(name))
                        newParams.put(name, value);   //replace same valid k-v from API to common params
                    else
                        urlBuilder.setQueryParameter(name, value); //if not in common params scope, put in query params directly
                }
            }

            for (Map.Entry<String, String> entry : newParams.entrySet()) {  //process common params
                if (!StringUtils.isEmpty(entry.getValue()))  // filter: value must be valid
                    urlBuilder.setQueryParameter(entry.getKey(), entry.getValue());  //set query params
            }
        } else if (request.method().equals(HttpMethod.POST) && request.body() instanceof FormBody) {
            FormBody.Builder formBodyBuilder = new FormBody.Builder();   //new FormBody

            for (int i = 0; i < ((FormBody) request.body()).size(); i++) {
                String name = ((FormBody) request.body()).name(i);
                String value = ((FormBody) request.body()).value(i);
                if (!value.isEmpty()) {
                    if (newParams.containsKey(name))
                        newParams.put(name, value);    //replace same valid k-v from API to common params
                    else
                        formBodyBuilder.add(name, value); //if not in common params scope, put in form body directly
                }
            }

            for (Map.Entry<String, String> entry : newParams.entrySet()) {
                if (!StringUtils.isEmpty(entry.getValue()))
                    formBodyBuilder.add(entry.getKey(), entry.getValue()); //new form body take it
            }
            newRequest.post(formBodyBuilder.build());  //set form body
        }

        for (Map.Entry<String, String> entry : newHeaderParams.entrySet()) {
            if(entry.getValue() != null) newRequest.header(entry.getKey(), entry.getValue()); //header value cant be null
        }

        return chain.proceed(newRequest.url(urlBuilder.build()).build());
    }

    abstract protected Map<String, String> onAddParams(Request request);
    //optional
     protected Map<String, String> onAddHeaderParams(Request request){
         return new HashMap<>();
     }
}
