package com.cv.media.lib.api;

import com.cv.media.lib.common_utils.callback.IAction;

class NetWorkEvent implements INetWorkEvent {
    private String path;
    private String method;
    private int tag;
    private IAction<String> desCb;
    private String des;
    private long timeCost;

    public NetWorkEvent(String path, String method, int tag, long timeCost, IAction<String> desCb) {
        this.path = path;
        this.method = method;
        this.tag = tag;
        this.desCb = desCb;
        this.timeCost = timeCost;
    }

    public void setDesCb(IAction<String> desCb) {
        this.desCb = desCb;
    }

    @Override
    public long getTotalCost() {
        return timeCost;
    }

    @Override
    public String getDescription() {
        if (des != null) return des;
        des = desCb != null ? desCb.get() : null;
        return des;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public String getMethod() {
        return method;
    }

    @Override
    public int getTag() {
        return tag;
    }
}
