package com.cv.media.lib.api;

import com.cv.media.lib.common_utils.obfuscation.KeepAll;
import com.cv.media.lib.common_utils.obfuscation.KeepClassMember;
import com.cv.media.lib.common_utils.pool.ObjectPool;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;

import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

/**
 * 描述一个IP+Port连接
 * 职责:
 *
 * @author Damon
 */
public class NW_IPPNode extends NW_Base implements KeepClassMember {
    private String des;
    private String host;
    private String ip;
    private String port;
    private String protocol;
    private final ArrayList<NW_ConnectionNode> connectionNodes = new ArrayList<>();
    private transient NW_ConnectionNode currentConnectionNode;
    private long dnsStartTs;
    private long dnsEndTs;

    private long requestHeaderSentStartTs;
    private long requestHeaderSentDoneTs;
    private long requestBodySentStartTs;
    private long requestBodySentDoneTs;
    private long requestBodySentDataLength;

    private long responseHeaderReceiveStartTs;
    private long responseHeaderReceiveDoneTs;
    private int responseCode;
    private long responseBodyReceiveStartTs;
    private long responseBodyReceiveDoneTs;
    private long responseBodyReceiveDataLength;
    private String callErrorMsg;

    public NW_IPPNode() {
        reset();
    }

    @Override
    void reset() {
        des = null;
        host = null;
        ip = null;
        port = null;
        protocol = null;
        currentConnectionNode = null;
        dnsStartTs = INVALID;
        dnsEndTs = INVALID;
        connectionNodes.clear();
        requestHeaderSentStartTs = INVALID;
        requestHeaderSentDoneTs = INVALID;
        requestBodySentStartTs = INVALID;
        requestBodySentDoneTs = INVALID;
        requestBodySentDataLength = INVALID;

        responseHeaderReceiveStartTs = INVALID;
        responseHeaderReceiveDoneTs = INVALID;
        responseCode = -1;
        responseBodyReceiveStartTs = INVALID;
        responseBodyReceiveDoneTs = INVALID;
        responseBodyReceiveDataLength = INVALID;
        callErrorMsg = null;
    }

    public void setDes(String des) {
        this.des = des;
    }

    @Override
    public void callStart(Call call) {
    }

    public void dnsStart(Call call, String domainName) {
        host = domainName;
        dnsStartTs = cts();
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        dnsEndTs = cts();
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        port = String.valueOf(inetSocketAddress.getPort());
        ip = inetSocketAddress.getAddress().getHostAddress();
        currentConnectionNode = ObjectPool.obtain(NW_ConnectionNode.class);
        currentConnectionNode.connectStart(call, inetSocketAddress, proxy);
        connectionNodes.add(currentConnectionNode);
    }

    public void secureConnectStart(Call call) {
        if (currentConnectionNode != null) currentConnectionNode.secureConnectStart(call);
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        if (currentConnectionNode != null) currentConnectionNode.secureConnectEnd(call, handshake);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy,
                           Protocol protocol) {
        if (currentConnectionNode != null)
            currentConnectionNode.connectEnd(call, inetSocketAddress, proxy, protocol);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy,
                              Protocol protocol, IOException ioe) {
        if (currentConnectionNode != null)
            currentConnectionNode.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
    }


    public void connectionAcquired(Call call, Connection connection) {
        if (host == null) host = connection.route().socketAddress().getAddress().getHostName();
        if (port == null) port = String.valueOf(connection.route().socketAddress().getPort());
        if (ip == null) ip = connection.route().socketAddress().getAddress().getHostAddress();
        if(protocol == null) protocol = connection.protocol().toString();
    }


    public void connectionReleased(Call call, Connection connection) {
    }


    public void requestHeadersStart(Call call) {
        requestHeaderSentStartTs = cts();
    }


    public void requestHeadersEnd(Call call, Request request) {
        requestHeaderSentDoneTs = cts();
    }

    public void requestBodyStart(Call call) {
        requestBodySentStartTs = cts();
    }


    public void requestBodyEnd(Call call, long byteCount) {
        requestBodySentDoneTs = cts();
        requestBodySentDataLength = byteCount;
    }


    public void responseHeadersStart(Call call) {
        responseHeaderReceiveStartTs = cts();
    }


    public void responseHeadersEnd(Call call, Response response) {
        responseHeaderReceiveDoneTs = cts();
        responseCode = response.code();
    }


    public void responseBodyStart(Call call) {
        responseBodyReceiveStartTs = cts();
    }


    public void responseBodyEnd(Call call, long byteCount) {
        responseBodyReceiveDoneTs = cts();
        responseBodyReceiveDataLength = byteCount;
    }


    public void callEnd(Call call) {
    }


    public void callFailed(Call call, IOException ioe) {
        callErrorMsg = ioe.toString();
    }


    @Override
    public void recycle() {
        for (NW_ConnectionNode connectionNode : connectionNodes) {
            connectionNode.recycle();
        }
        super.recycle();
    }
}
