package com.cv.media.lib.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;

import okhttp3.Interceptor;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

class NetWorkApiWrapper<T> {
    private T api;
    private T wrapper;
    private static List<Method> methodsBase;
    private NetWorkApiImpl netWorkApiImpl;

    static {
        methodsBase = Arrays.asList(NetWorkApi.class.getDeclaredMethods());
    }
    public NetWorkApiWrapper(Class<T> apiClass, T api) {
        this.api = api;
        netWorkApiImpl = new NetWorkApiImpl();
        wrapper = (T) Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (proxy, method, args) -> {
            if (method.getReturnType() == NetWorkApi.class) {
                return netWorkApiImpl;
            }
            try {
                return method.invoke(api, args);
            } catch (Throwable e) {
                if (e.getCause() != null) throw e.getCause();
                else throw e;
            }
        });
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        for (Interceptor interceptor : interceptors) {
            if (interceptor instanceof BaseHostSwitchInterceptor) netWorkApiImpl.hostInterceptor = (BaseHostSwitchInterceptor) interceptor;
        }
    }

    T getWrap() {
        return wrapper;
    }
}
